/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.util.Optional;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.api.component.location.Location;

public class ComponentModelLocatorHelper {
    public Optional<ComponentAst> findComponentModel(ArtifactAst applicationModel, Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional<ComponentAst> globalComponent = applicationModel.topLevelComponentsStream().filter(cm -> location.getGlobalName().equals(cm.getComponentId().orElse(null))).findFirst();
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentAst)componentModel, location).ifPresent(foundComponentModel -> foundComponentModelReference.set(foundComponentModel)));
        return Optional.ofNullable((ComponentAst)foundComponentModelReference.get());
    }

    private Optional<ComponentAst> findComponentWithLocation(ComponentAst componentModel, Location location) {
        if (componentModel.getLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        return componentModel.directChildrenStream().map(childComponent -> this.findComponentWithLocation((ComponentAst)childComponent, location)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

