/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolverProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.DefaultApplicationModelFactory;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.AbstractArtifact;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;

public class DefaultDomain
extends AbstractArtifact<DomainDescriptor>
implements Domain {
    private final ReentrantReadWriteLock deploymentLock = new ReentrantReadWriteLock();

    public DefaultDomain(String id, ArtifactResources artifactResources, DomainDescriptor domainDescriptor, ToolingArtifactContext context, Map<String, String> properties) {
        super(id, artifactResources, domainDescriptor, context, properties);
    }

    @Override
    public DomainDescriptor getDescriptor() {
        return (DomainDescriptor)this.artifactDescriptor;
    }

    @Override
    protected LazyValue<ToolingArtifactClassLoader> newToolingArtifactClassLoaderLazyValue() {
        return new LazyValue(() -> this.context.getDomainClassLoaderFactory().createDomainClassLoader((DomainDescriptor)this.artifactDescriptor, this.artifactResources.getWorkingDirectory()));
    }

    @Override
    protected LazyValue<ToolingApplicationModel> newToolingApplicationModelLazyValue() {
        return new LazyValue(() -> {
            Function configurationPropertiesResolver = ClassUtils.memoize(originalAst -> ConfigurationPropertiesResolverProvider.builder().from(originalAst).withParentProperties(Optional.of(this.noFailureConfigurationProperties)).withDeploymentProperties(this.getProperties()).loadingResourcesWith(this.getArtifactClassLoader().getClassLoader()).build(), new HashMap());
            ArtifactAst ast = new DefaultApplicationModelFactory().createApplicationModel(this.artifactDescriptor, this.getAstXmlParser(), this.getArtifactClassLoader().getClassLoader(), configurationPropertiesResolver.andThen(ConfigurationPropertiesResolverProvider::getConfigurationPropertiesResolver)).orElseThrow(() -> new ToolingException(String.format("Couldn't create ApplicationModel from %s", this)));
            return new ToolingApplicationModel(null, ast, (ConfigurationProperties)configurationPropertiesResolver.apply(ast), this.getArtifactClassLoader().getClassLoader());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R evaluateWithRemoteDomain(RemoteDomainInvoker.DomainRemoteFunction<R> function) {
        ReentrantReadWriteLock.WriteLock writeLock;
        this.checkState();
        if (!this.deployed && (writeLock = this.deploymentLock.writeLock()).tryLock()) {
            try {
                if (!this.deployed) {
                    this.deployed = true;
                    this.remoteArtifactId = this.artifactDeployer.deploy(null);
                    R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
                    return r;
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        ReentrantReadWriteLock.ReadLock readLock = this.deploymentLock.readLock();
        readLock.lock();
        try {
            R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
            return r;
        }
        finally {
            readLock.unlock();
        }
    }
}

