/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.utils.ExtensionModelUtils;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslSyntaxServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE = "tooling.client.DslSyntaxServiceCache.cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(DslSyntaxServiceCache.class);
    private final Cache<List<ArtifactDescriptor>, DslResolvingContext> dslContextCache;
    private final Cache<ExtensionModel, DslSyntaxResolver> dslResolverCache;

    public DslSyntaxServiceCache() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initialising DSL Syntax cache");
        }
        this.dslContextCache = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.dslResolverCache = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).expireAfterWrite(10L, TimeUnit.MINUTES).weakKeys().build();
    }

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE, "100"));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE));
        return cacheSize;
    }

    public DslResolvingContext getContext(List<ArtifactDescriptor> artifactDescriptors, MavenClient mavenClient, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider) {
        return ServiceUtils.executeHandlingException(() -> (DslResolvingContext)this.dslContextCache.get((Object)artifactDescriptors, () -> ExtensionModelUtils.createDslResolvingContext(muleRuntimeExtensionModelProvider.getRuntimeExtensionModels(), ExtensionModelUtils.resolveExtensionModels(mavenClient, muleRuntimeExtensionModelProvider, ExtensionModelUtils.toBundleDescriptors(artifactDescriptors)))));
    }

    public DslSyntaxResolver getResolver(ExtensionModel extensionModel, DslResolvingContext context) {
        return ServiceUtils.executeHandlingException(() -> (DslSyntaxResolver)this.dslResolverCache.get((Object)extensionModel, () -> DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)context)));
    }

    public void invalidate(List<ArtifactDescriptor> plugins) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Invalidating DSL Context cache");
        }
        try {
            DslResolvingContext dslResolvingContext = (DslResolvingContext)this.dslContextCache.getIfPresent(plugins);
            if (dslResolvingContext != null) {
                dslResolvingContext.getExtensions().forEach(arg_0 -> this.dslResolverCache.invalidate(arg_0));
            }
            this.dslContextCache.invalidate(plugins);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to invalidate the DSL Context cache: " + e.getMessage(), (Throwable)e);
            }
            this.dispose();
        }
    }

    public void invalidate(List<ArtifactDescriptor> plugins, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Invalidating DSL Resolvers cache for extension: " + toolingModel.getName());
        }
        try {
            ((DslResolvingContext)this.dslContextCache.getIfPresent(plugins)).getExtension(toolingModel.getName()).ifPresent(arg_0 -> this.dslResolverCache.invalidate(arg_0));
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to invalidate the DSL Resolvers cache: " + e.getMessage(), (Throwable)e);
            }
            this.dispose();
        }
    }

    public void dispose() {
        block3: {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalidating DSL Syntax cache");
            }
            try {
                this.dslContextCache.invalidateAll();
                this.dslResolverCache.invalidateAll();
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("Failed to invalidate the DSL Syntax cache: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

