/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.introspection;

import com.mulesoft.runtime.introspector.IntrospectionRequest;
import com.mulesoft.runtime.introspector.IntrospectionResult;
import com.mulesoft.runtime.introspector.MuleArtifactIntrospector;
import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import java.nio.file.Path;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.tooling.client.api.introspection.IntrospectionAPIException;
import org.mule.tooling.client.api.introspection.IntrospectionAPIResponse;
import org.mule.tooling.client.api.introspection.IntrospectionService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.introspection.IntrospectionAPIResponseMapper;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultIntrospectionService
implements IntrospectionService,
Command {
    private final LazyValue<ClassLoader> executionClassLoader;
    private final LazyValue<ArtifactAst> artifactAst;
    private final Serializer serializer;

    public DefaultIntrospectionService(LazyValue<ClassLoader> executionClassLoader, LazyValue<ArtifactAst> artifactAst, Serializer serializer) {
        this.executionClassLoader = executionClassLoader;
        this.artifactAst = artifactAst;
        this.serializer = serializer;
    }

    public IntrospectionAPIResponse getBillableFlows() {
        IntrospectionRequest parameters = IntrospectionRequest.builder().withAppClassloader((ClassLoader)this.executionClassLoader.get()).withArtifactAst((ArtifactAst)this.artifactAst.get()).build();
        try {
            return this.buildBillableFlowsResponse(new MuleArtifactIntrospector().introspectAppAst(parameters));
        }
        catch (IntrospectionException e) {
            throw new IntrospectionAPIException((Throwable)e);
        }
    }

    public IntrospectionAPIResponse getJava17Compatibility(Path artifactPath) {
        IntrospectionRequest parameters = IntrospectionRequest.builder().withArtifactPath(artifactPath).build();
        try {
            return this.buildJava17CompatibilityResponse(new MuleArtifactIntrospector().introspectAppAst(parameters));
        }
        catch (IntrospectionException e) {
            throw new IntrospectionAPIException((Throwable)e);
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getBillableFlows": {
                Preconditions.checkState((arguments.length == 0 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 0 ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.getBillableFlows());
            }
            case "getJava17Compatibility": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(Path.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.getJava17Compatibility((Path)this.serializer.deserialize(arguments[0])));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    private IntrospectionAPIResponse buildBillableFlowsResponse(IntrospectionResult introspectionResult) {
        return IntrospectionAPIResponse.newBuilder().withFlows(IntrospectionAPIResponseMapper.get(introspectionResult.getFlows())).build();
    }

    private IntrospectionAPIResponse buildJava17CompatibilityResponse(IntrospectionResult introspectionResult) {
        return IntrospectionAPIResponse.newBuilder().withApiImplementation(IntrospectionAPIResponseMapper.get(introspectionResult.getJavaComponents())).build();
    }
}

