/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;
import org.mule.tooling.client.internal.InternalSchemaService;
import org.mule.tooling.client.internal.utils.SchemaGetterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaService
implements InternalSchemaService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SchemaGetterUtils schemaGetterUtils;

    public DefaultSchemaService(SchemaGetterUtils schemaGetterUtils) {
        this.schemaGetterUtils = schemaGetterUtils;
    }

    @Override
    public Optional<String> getSchema(File pluginJarFile) {
        Optional<String> xsdSchemaString = Optional.empty();
        try {
            Optional<File> schemaFile = this.schemaGetterUtils.getSchemaFile(pluginJarFile);
            if (schemaFile.isPresent()) {
                xsdSchemaString = Optional.of(new String(Files.readAllBytes(schemaFile.get().toPath())));
            }
        }
        catch (IOException e) {
            this.logger.error("Error getting schema from file: {}", (Object)pluginJarFile.getAbsolutePath(), (Object)e);
        }
        return xsdSchemaString;
    }
}

