/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherResolutionContext;
import org.mule.maven.client.internal.DefaultLocalRepositorySupplierFactory;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.test.utils.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.utils.MuleStandaloneController;
import org.mule.tooling.client.test.utils.PortUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleRuntimeTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleRuntimeTestCase.class);
    protected static final int DEFAULT_START_TIMEOUT = 50000;
    protected static final int DEFAULT_START_POLL_INTERVAL = 500;
    protected static final int DEFAULT_START_POLL_DELAY = 300;
    protected static final int DEFAULT_CONTROLLER_OPERATION_TIMEOUT = 15000;
    public static final String HTTP = "http";
    private static final String MULESOFT_PUBLIC_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/public/";
    private static final String MULESOFT_PRIVATE_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/private/";
    public static final String RUNTIMES_FOLDER = "runtimes";
    public static final String REST_AGENT_TRANSPORT_PORT_SYS_PROP = "-M-Drest.agent.transport.port=";
    public static final String MULE_RUNTIME_TOOLING_CLIENT = "mule-runtime-tooling-client";
    public static final String MULE_TOOLING_API_VERSION = "mule.tooling.api.version";
    public static final String POM_XML = "pom.xml";
    private static String muleDir = System.getProperty("MULE_HOME");
    protected MuleStandaloneController muleStandaloneController;
    protected int agentPort = PortUtils.findFreePort();
    protected AgentConfiguration defaultAgentConfiguration;
    protected MavenConfiguration defaultMavenConfiguration;
    protected List<String> defaultMuleStartArguments;
    private static String muleVersion;
    @ClassRule
    public static TemporaryFolder temporaryFolder;

    @Before
    public final void before() throws Exception {
        if (muleDir == null) {
            File targetFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
            File runtimesFolder = new File(targetFolder, RUNTIMES_FOLDER);
            String[] runtimes = runtimesFolder.list((FilenameFilter)new WildcardFileFilter("mule*"));
            Assert.assertThat((Object)runtimes, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
            muleDir = new File(runtimesFolder, runtimes[0]).getAbsolutePath();
        }
        this.defaultMavenConfiguration = AbstractMuleRuntimeTestCase.createDefaultMavenConfiguration();
        this.muleStandaloneController = new MuleStandaloneController(new File(muleDir), new MuleStandaloneConfiguration(50000L, 500L, 300L, 15000L));
        RemoteRepository privateRepository = new RemoteRepository.Builder("mulesoft-private", null, null).build();
        Optional authenticatorSelector = new AetherResolutionContext(this.defaultMavenConfiguration).getAuthenticatorSelector();
        if (!authenticatorSelector.isPresent()) {
            throw new IllegalStateException("Couldn't find Server entries on Maven user settings.xml");
        }
        Authentication authentication = ((AuthenticationSelector)authenticatorSelector.get()).getAuthentication(privateRepository);
        if (authentication == null) {
            throw new IllegalStateException("Couldn't find Server entry on Maven user settings.xml for mulesoft-private");
        }
        this.defaultMuleStartArguments = Lists.newArrayList((Object[])new String[]{REST_AGENT_TRANSPORT_PORT_SYS_PROP + this.agentPort, "-M-DmuleRuntimeConfig.maven.repositoryLocation=" + this.defaultMavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath(), "-M-DmuleRuntimeConfig.maven.repositories.mulesoft-public.url=https://repository.mulesoft.org/nexus/content/repositories/public/", "-M-DmuleRuntimeConfig.maven.repositories.mulesoft-private.url=https://repository.mulesoft.org/nexus/content/repositories/private/"});
        this.defaultMavenConfiguration.getUserSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add("-M-DmuleRuntimeConfig.maven.userSettingsLocation=" + file.getAbsolutePath()));
        this.defaultMavenConfiguration.getGlobalSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add("-M-DmuleRuntimeConfig.maven.globalSettingsLocation=" + file.getAbsolutePath()));
        if (Boolean.valueOf(System.getProperty("muleRuntime.debug.enabled")).booleanValue()) {
            this.defaultMuleStartArguments.add("-debug");
        }
        String localhost = InetAddress.getLocalHost().getHostAddress();
        this.defaultAgentConfiguration = AgentConfiguration.newAgentConfigurationBuilder().withDefaultConnectionTimeout(5000).withDefaultReadTimeout(50000).withToolingApiURLSupplier(() -> "http://" + localhost + ":" + this.agentPort + "/mule/tooling").build();
        if (this.isStartMuleBeforeEachTest()) {
            this.startMuleRuntime();
        }
    }

    public static MavenConfiguration createDefaultMavenConfiguration() throws IOException {
        MavenConfiguration mavenConfiguration = AbstractMuleRuntimeTestCase.createDefaultMavenConfigurationBuilder().build();
        LOGGER.info("Using MavenConfiguration {}", (Object)mavenConfiguration);
        return mavenConfiguration;
    }

    public static MavenConfiguration.MavenConfigurationBuilder createDefaultMavenConfigurationBuilder() throws IOException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().withForcePolicyUpdateNever(true);
        File localMavenRepository = (File)new DefaultLocalRepositorySupplierFactory().environmentMavenRepositorySupplier().get();
        mavenConfigurationBuilder.withLocalMavenRepositoryLocation(localMavenRepository);
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        mavenConfigurationBuilder.withRemoteRepository(org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder().withId("mulesoft-public").withUrl(new URL(MULESOFT_PUBLIC_REPOSITORY)).build());
        mavenConfigurationBuilder.withRemoteRepository(org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder().withId("mulesoft-private").withUrl(new URL(MULESOFT_PRIVATE_REPOSITORY)).build());
        settingsSupplierFactory.environmentUserSettingsSupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).withUserSettingsLocation(arg_0));
        settingsSupplierFactory.environmentGlobalSettingsSupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).withGlobalSettingsLocation(arg_0));
        return mavenConfigurationBuilder;
    }

    public static String getMuleVersion() {
        if (muleVersion == null) {
            File toolingRuntimeDependenciesPomFile;
            try {
                toolingRuntimeDependenciesPomFile = new File(new File(new File(AbstractMuleRuntimeTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile(), MULE_RUNTIME_TOOLING_CLIENT), POM_XML);
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            Model mavenProject = AbstractMuleRuntimeTestCase.createMavenProject(toolingRuntimeDependenciesPomFile);
            String version = mavenProject.getVersion();
            if (version != null) {
                if (version.startsWith("${") && version.endsWith("}")) {
                    Model parentProject = AbstractMuleRuntimeTestCase.createMavenProject(new File(toolingRuntimeDependenciesPomFile.getParentFile(), mavenProject.getParent().getRelativePath()));
                    String resolvedVersion = (String)parentProject.getProperties().get(version.substring(version.indexOf("{") + 1, version.lastIndexOf("}")));
                    if (resolvedVersion != null) {
                        muleVersion = resolvedVersion;
                    }
                } else {
                    muleVersion = version;
                }
            } else {
                muleVersion = mavenProject.getParent().getVersion();
            }
        }
        return muleVersion;
    }

    public static String getToolingVersion() {
        File toolingRuntimeDependenciesPomFile;
        try {
            toolingRuntimeDependenciesPomFile = new File(new File(AbstractMuleRuntimeTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile(), POM_XML);
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        Model mavenProject = AbstractMuleRuntimeTestCase.createMavenProject(toolingRuntimeDependenciesPomFile);
        Object result = mavenProject.getProperties().get(MULE_TOOLING_API_VERSION);
        return result != null ? result.toString() : mavenProject.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model createMavenProject(File pomFile) {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        if (pomFile == null) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        if (!pomFile.exists()) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        try (FileReader reader = new FileReader(pomFile);){
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get Maven Artifact from pom: " + pomFile);
        }
    }

    protected void startMuleRuntime() {
        ArrayList args = Lists.newArrayList(this.defaultMuleStartArguments);
        args.addAll(Arrays.asList(this.getStartMuleArguments()));
        this.muleStandaloneController.start(args.toArray(new String[0]), this.getProtocol());
    }

    protected String getProtocol() {
        return HTTP;
    }

    @After
    public final void after() {
        if (this.muleStandaloneController.isRunning()) {
            this.muleStandaloneController.stop();
        }
    }

    @AfterClass
    public static void checkDisposedApps() {
        File toolingDir = new File(muleDir + "/tmp/tooling");
        if (toolingDir.exists()) {
            Assert.assertThat((Object)toolingDir.listFiles().length, (Matcher)Matchers.is((Object)0));
        }
    }

    protected String[] getStartMuleArguments() {
        return new String[0];
    }

    protected boolean isStartMuleBeforeEachTest() {
        return true;
    }

    public static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while getting URL", e);
        }
    }

    static {
        temporaryFolder = new TemporaryFolder();
    }
}

