/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.test.utils;

import java.util.function.Supplier;

public class FailIfCalledTwoTimesSupplier<T> implements Supplier<T> {

  final Supplier<T> delegate;
  transient volatile boolean initialized;

  public FailIfCalledTwoTimesSupplier(Supplier<T> delegate) {
    this.delegate = delegate;
  }

  public T get() {
    if (!initialized) {
      synchronized (this) {
        if (!initialized) {
          T t = delegate.get();
          initialized = true;
          return t;
        }
      }
    }
    throw new AssertionError("Shouldn't be called more than one time");
  }
}
