/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.test.utils;

import java.io.IOException;
import java.net.ServerSocket;

/**
 * Utility to find free ports.
 *
 * @since 1.0
 */
public class PortUtils {

  /**
   * @return a free port number on localhost.
   * @throws IllegalArgumentException if a free port couldn't be found.
   */
  public static int findFreePort() throws IllegalStateException {
    ServerSocket socket = null;
    try {
      socket = new ServerSocket(0);
      return socket.getLocalPort();
    } catch (IOException e) {
    } finally {
      if (socket != null) {
        try {
          socket.close();
        } catch (IOException e) {
        }
      }
    }
    throw new IllegalStateException("Couldn't find a free port");
  }
}
