/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.StringUtils;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.mule.tooling.client.test.utils.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.utils.PortUtils;
import org.mule.tooling.runtime.process.controller.MuleProcessController;
import org.mule.tooling.runtime.process.controller.MuleProcessControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleStandaloneController {
    public static final String MULE_JAVA_PREFIX_PARAM = "-M-D";
    public static final String EQUALS_CONST = "=";
    public static final String MULE_TOOLING_RESOURCE = "/mule/tooling";
    private static final String HTTPS_PROTOCOL = "https";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MULE_AGENT_REST_TRANSPORT_PORT_PROPERTY = "-M-Drest.agent.transport.port";
    private MuleStandaloneConfiguration configuration;
    private MuleProcessController muleProcessController;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public MuleStandaloneController(File muleHome, MuleStandaloneConfiguration configuration) {
        Objects.requireNonNull(muleHome, "muleHome cannot be null");
        Objects.requireNonNull(configuration, "configuration cannot be null");
        this.configuration = configuration;
        this.muleProcessController = MuleProcessControllerFactory.createController((File)muleHome, (long)configuration.getControllerOperationTimeout());
    }

    public void start(String[] args, String protocol) {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                int restAgentPort;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Starting client");
                }
                List<String> parameters = Arrays.asList(args);
                parameters.removeIf(StringUtils::isBlank);
                Optional<String> agentPortParameter = this.findAgentPortParameter(parameters);
                if (!agentPortParameter.isPresent()) {
                    restAgentPort = PortUtils.findFreePort();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found a free port for Mule Agent REST at: {}", (Object)restAgentPort);
                    }
                    parameters.add("-M-Drest.agent.transport.port=" + restAgentPort);
                } else {
                    restAgentPort = Integer.parseInt(agentPortParameter.get().split(EQUALS_CONST)[1]);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Port for Mule Agent REST already defined as parameter: {}", (Object)restAgentPort);
                    }
                }
                this.muleProcessController.start(parameters.toArray(new String[0]));
                this.waitUnilRuntimeToolingServiceIsOperational(this.getToolingApiUrl(protocol, restAgentPort));
            }
            catch (Exception e) {
                this.stop();
                throw new IllegalStateException("Error while starting client", e);
            }
        } else {
            this.logger.warn("Client already started");
        }
    }

    private Optional<String> findAgentPortParameter(List<String> parameters) {
        return parameters.stream().filter(item -> item.startsWith(MULE_JAVA_PREFIX_PARAM) && item.split(EQUALS_CONST)[0].equals(MULE_AGENT_REST_TRANSPORT_PORT_PROPERTY)).findFirst();
    }

    private void waitUnilRuntimeToolingServiceIsOperational(URL toolingApiUrl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Waiting for Tooling API URL to be operational...");
        }
        Awaitility.with().timeout(this.configuration.getStartTimeout() == 0L ? Duration.FOREVER : new Duration(this.configuration.getStartTimeout(), TimeUnit.MILLISECONDS)).and().with().pollInterval(this.configuration.getStartPollInterval(), TimeUnit.MILLISECONDS).and().with().pollDelay(this.configuration.getStartPollDelay(), TimeUnit.MILLISECONDS).await("Waiting for Remote Tooling Service to be operational").until(() -> {
            URLConnection urlConnection = toolingApiUrl.openConnection();
            urlConnection.setConnectTimeout(200);
            urlConnection.setReadTimeout(200);
            try {
                urlConnection.connect();
                return true;
            }
            catch (Exception e) {
                return toolingApiUrl.getProtocol().equals(HTTPS_PROTOCOL) && e instanceof SSLHandshakeException;
            }
        });
    }

    public boolean isRunning() {
        return this.muleProcessController.isRunning();
    }

    public void stop() {
        try {
            if (this.muleProcessController != null && this.muleProcessController.isRunning()) {
                this.muleProcessController.stop();
            }
            this.initialized.getAndSet(false);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't stop Mule Runtime", (Throwable)e);
        }
    }

    private URL getToolingApiUrl(String protocol, int restAgentPort) throws MalformedURLException, UnknownHostException {
        return new URL(protocol + "://" + InetAddress.getLocalHost().getHostAddress() + ":" + restAgentPort + MULE_TOOLING_RESOURCE);
    }
}

