/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.runtime.api.exception.MuleRuntimeException;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void compress(File targetFile, File folder) {
        ZipResource[] resources = ZipUtils.getZipResources(folder);
        ZipUtils.compress(targetFile, resources);
    }

    private static ZipResource[] getZipResources(File folder) {
        try {
            ArrayList resources = new ArrayList();
            Files.walk(folder.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> resources.add(new ZipResource(f.toFile().getAbsolutePath(), ZipUtils.getRelativePath(folder, f.toFile()))));
            return resources.toArray(new ZipResource[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getRelativePath(File targetFolder, File file) {
        return file.getAbsolutePath().substring(targetFolder.getAbsolutePath().length() + 1);
    }

    private static void compress(File targetFile, ZipResource[] resources) {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));){
            for (ZipResource zipResource : resources) {
                URL resourceUrl = ZipUtils.class.getClassLoader().getResource(zipResource.file);
                URI resourceUri = resourceUrl == null ? new File(zipResource.file).toURI() : resourceUrl.toURI();
                try (FileInputStream in = new FileInputStream(new File(resourceUri));){
                    int count;
                    out.putNextEntry(new ZipEntry(zipResource.alias == null ? zipResource.file : zipResource.alias));
                    byte[] buffer = new byte[1024];
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static class ZipResource {
        private final String file;
        private final String alias;

        public ZipResource(String file, String alias) {
            this.file = file;
            this.alias = alias;
        }
    }
}

