/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils.matchers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;

public class DataWeaveMatcher
extends TypeSafeMatcher<String> {
    private static final String START_INTERNAL_MATCHER_ERROR = "[internal matcher error -> ";
    private static final String END_INTERNAL_MATCHER_ERROR = "]";
    private final String objectClassName;
    private final WeaveMatcherField[] weaveMatcherFields;
    private StringBuilder mismatchingDescription = new StringBuilder();

    public DataWeaveMatcher(String objectClassName, WeaveMatcherField ... weaveMatcherFields) {
        this.objectClassName = objectClassName;
        this.weaveMatcherFields = weaveMatcherFields;
    }

    private Matcher withSomeEncoding() {
        return CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)String.format("{class: \"%s\", encoding: \"UTF-8\"}", this.objectClassName)), (Matcher)CoreMatchers.equalTo((Object)String.format("{class: \"%s\", encoding: \"US-ASCII\"}", this.objectClassName)));
    }

    protected boolean matchesSafely(String object) {
        String[] weaveSplit = object.split("as Object");
        String asObject = weaveSplit[1].trim();
        boolean matches = this.internalEvaluate(asObject, this.withSomeEncoding());
        Object[] fields = weaveSplit[0].split(",");
        ArrayList fieldLists = Lists.newArrayList((Object[])fields);
        return matches &= this.internalEvaluate(fieldLists, (Matcher)new IsIterableContainingInAnyOrder((Collection)Arrays.stream(this.weaveMatcherFields).map(weaveMatcherField -> weaveMatcherField.asMatcher()).collect(Collectors.toList())));
    }

    private boolean internalEvaluate(Object object, Matcher matcher) {
        boolean matches = matcher.matches(object);
        if (!matches) {
            StringDescription description = new StringDescription();
            matcher.describeMismatch(object, (Description)description);
            this.mismatchingDescription.append(System.lineSeparator());
            this.mismatchingDescription.append(START_INTERNAL_MATCHER_ERROR);
            this.mismatchingDescription.append(description);
            this.mismatchingDescription.append(END_INTERNAL_MATCHER_ERROR);
        }
        return matches;
    }

    public void describeTo(Description description) {
        description.appendText(this.mismatchingDescription.toString());
    }

    public static DataWeaveMatcher weaveMatcher(String objectClassName, WeaveMatcherField ... weaveMatcherFields) {
        return new DataWeaveMatcher(objectClassName, weaveMatcherFields);
    }

    public static class WeaveMatcherField {
        private final String fieldName;
        private final String fieldValue;
        private final String type;
        private final String className;

        private WeaveMatcherField(String fieldName, String fieldValue, String type, String className) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
            this.type = type;
            this.className = className;
        }

        Matcher asMatcher() {
            return CoreMatchers.containsString((String)String.format("%s: %s as %s {class: \"%s\"}", this.fieldName, this.fieldValue, this.type, this.className));
        }

        public String toString() {
            return "WeaveMatcherField{fieldName='" + this.fieldName + '\'' + ", fieldValue='" + this.fieldValue + '\'' + ", type='" + this.type + '\'' + ", className='" + this.className + '\'' + '}';
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private String fieldName;
            private String fieldValue;
            private String type;
            private String className;

            public Builder withFieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public Builder withFieldValue(String fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            public Builder asType(String type) {
                this.type = type;
                return this;
            }

            public Builder withClassName(String className) {
                this.className = className;
                return this;
            }

            public WeaveMatcherField build() {
                return new WeaveMatcherField(this.fieldName, this.fieldValue, this.type, this.className);
            }
        }
    }
}

