/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mashape.unirest.http.Unirest;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.test.MavenTestHelper;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.test.RuntimeType;
import org.mule.tooling.client.test.utils.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.utils.MuleStandaloneController;
import org.mule.tooling.client.test.utils.SystemPropertiesManager;
import org.mule.tooling.client.test.utils.probe.PollingProber;
import org.mule.tooling.client.test.utils.probe.Probe;

@RunWith(value=Parameterized.class)
public abstract class AbstractMuleRuntimeTestCase {
    protected static final int DEFAULT_START_TIMEOUT = 50000;
    protected static final int DEFAULT_START_POLL_INTERVAL = 500;
    protected static final int DEFAULT_START_POLL_DELAY = 300;
    protected static final int DEFAULT_CONTROLLER_OPERATION_TIMEOUT = 15000;
    public static final String HTTP = "http";
    private static final String MULESOFT_PUBLIC_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/public/";
    private static final String MULESOFT_PRIVATE_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/private/";
    public static final String RUNTIMES_FOLDER = "runtimes";
    public static final String REST_AGENT_TRANSPORT_PORT_SYS_PROP = "rest.agent.transport.port";
    public static final String MULE_RUNTIME_TOOLING_CLIENT = "mule-runtime-tooling-client";
    public static final String MULE_TOOLING_API_VERSION = "mule.tooling.api.version";
    public static final String POM_XML = "pom.xml";
    private static String muleDir = System.getProperty("MULE_HOME");
    protected final RuntimeType runtimeType;
    protected MuleStandaloneController muleStandaloneController;
    protected AgentConfiguration defaultAgentConfiguration;
    protected MavenConfiguration defaultMavenConfiguration;
    protected List<ImmutablePair<String, String>> defaultMuleStartArguments;
    protected Optional<EmbeddedContainer> embeddedContainerOptional = Optional.empty();
    private static String muleVersion;
    private SystemPropertiesManager systemPropertiesManager;
    private boolean runtimeStarted = false;
    @ClassRule
    public static TemporaryFolder temporaryFolder;
    @Rule
    public DynamicPort agentPort = new DynamicPort("agentPort");

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({RuntimeType.EMBEDDED}, {RuntimeType.REMOTE});
    }

    public AbstractMuleRuntimeTestCase(RuntimeType runtimeType) {
        this.runtimeType = runtimeType;
    }

    @Before
    public void before() throws Exception {
        this.defaultMavenConfiguration = MavenTestHelper.createDefaultEnterpriseMavenConfiguration();
        this.defaultMuleStartArguments = Lists.newArrayList((Object[])new ImmutablePair[]{ImmutablePair.of((Object)REST_AGENT_TRANSPORT_PORT_SYS_PROP, (Object)String.valueOf(this.agentPort.getNumber())), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositoryLocation", (Object)this.defaultMavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath()), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositories.mulesoft-public.url", (Object)MULESOFT_PUBLIC_REPOSITORY), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositories.mulesoft-private.url", (Object)MULESOFT_PRIVATE_REPOSITORY)});
        this.defaultMavenConfiguration.getUserSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"muleRuntimeConfig.maven.userSettingsLocation", (Object)file.getAbsolutePath())));
        this.defaultMavenConfiguration.getGlobalSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"muleRuntimeConfig.maven.globalSettingsLocation", (Object)file.getAbsolutePath())));
        if (Boolean.valueOf(System.getProperty("muleRuntime.debug.enabled")).booleanValue()) {
            this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"debug", (Object)""));
        }
        String toolingApiUrl = this.getAgentToolingUrl();
        this.defaultAgentConfiguration = AgentConfiguration.newAgentConfigurationBuilder().defaultConnectionTimeout(5000).defaultReadTimeout(50000).toolingApiUrl(AbstractMuleRuntimeTestCase.toUrl(new URI(toolingApiUrl))).build();
        if (this.runtimeType.equals((Object)RuntimeType.REMOTE)) {
            if (muleDir == null) {
                File targetFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
                File runtimesFolder = new File(targetFolder, RUNTIMES_FOLDER);
                String[] runtimes = runtimesFolder.list((FilenameFilter)new WildcardFileFilter("mule*"));
                Assert.assertThat((Object)runtimes, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
                muleDir = new File(runtimesFolder, runtimes[0]).getAbsolutePath();
            }
            this.cleanUpRemoteServerTlsConfiguration();
            this.muleStandaloneController = new MuleStandaloneController(new File(muleDir), new MuleStandaloneConfiguration(50000L, 500L, 300L, 15000L));
        } else {
            this.systemPropertiesManager = new SystemPropertiesManager((List<ImmutablePair<String, String>>)ImmutableList.builder().add((Object)ImmutablePair.of((Object)"mule.testingMode", (Object)"true")).add((Object)ImmutablePair.of((Object)"org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", (Object)"org.glassfish.grizzly.memory.HeapMemoryManager")).addAll(this.getAllStartupArguments()).build());
        }
        if (this.isStartMuleBeforeEachTest()) {
            this.startMuleRuntime();
        }
    }

    protected String getAgentUrl() {
        try {
            String localhost = InetAddress.getLocalHost().getHostAddress();
            return "http://" + localhost + ":" + this.agentPort.getNumber();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAgentToolingUrl() {
        try {
            return this.getAgentUrl() + "/mule/tooling";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAgentApplicationsUrl() {
        try {
            return this.getAgentUrl() + "/mule/applications";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void cleanUpRemoteServerTlsConfiguration() {
        File confFolder = new File(muleDir, "conf");
        FileUtils.deleteQuietly((File)new File(confFolder, "mule-agent-default.yml"));
        FileUtils.deleteQuietly((File)new File(confFolder, "mule-agent.yml"));
    }

    public static String getMuleVersion() {
        if (muleVersion == null) {
            File toolingRuntimeDependenciesPomFile;
            muleVersion = System.getProperty("tooling.test.mule.version");
            if (muleVersion != null) {
                return muleVersion;
            }
            try {
                toolingRuntimeDependenciesPomFile = new File(new File(new File(AbstractMuleRuntimeTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile(), MULE_RUNTIME_TOOLING_CLIENT), POM_XML);
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            Model mavenProject = AbstractMuleRuntimeTestCase.createMavenProject(toolingRuntimeDependenciesPomFile);
            String version = (String)AbstractMuleRuntimeTestCase.createMavenProject(new File(mavenProject.getParent().getRelativePath())).getProperties().get("mule.version");
            if (version != null) {
                muleVersion = version;
            } else {
                throw new IllegalStateException("Couldn't obtain mule.version property from parent pom");
            }
        }
        return muleVersion;
    }

    public static String getToolingVersion() {
        File toolingRuntimeDependenciesPomFile;
        String toolingApiVersion = System.getProperty("tooling.test.api.version");
        if (toolingApiVersion != null) {
            return toolingApiVersion;
        }
        try {
            toolingRuntimeDependenciesPomFile = new File(new File(AbstractMuleRuntimeTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile(), POM_XML);
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        Model mavenProject = AbstractMuleRuntimeTestCase.createMavenProject(toolingRuntimeDependenciesPomFile);
        Object result = mavenProject.getProperties().get(MULE_TOOLING_API_VERSION);
        return result != null ? result.toString() : mavenProject.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model createMavenProject(File pomFile) {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        if (pomFile == null) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        if (!pomFile.exists()) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        try (FileReader reader = new FileReader(pomFile);){
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get Maven Artifact from pom: " + pomFile);
        }
    }

    protected void startMuleRuntime() {
        if (this.runtimeStarted) {
            throw new RuntimeException("Runtime already started");
        }
        this.runtimeStarted = true;
        if (this.runtimeType.equals((Object)RuntimeType.EMBEDDED)) {
            try {
                this.systemPropertiesManager.set();
                EmbeddedContainer embeddedContainer = EmbeddedContainer.builder().muleVersion(AbstractMuleRuntimeTestCase.getMuleVersion()).log4jConfigurationFile(this.getClass().getClassLoader().getResource("log4j2-default.xml").toURI()).mavenConfiguration(this.defaultMavenConfiguration).containerConfiguration(ContainerConfiguration.builder().containerFolder(temporaryFolder.newFolder()).serverPlugins(new BundleDescriptor[]{new BundleDescriptor.Builder().setGroupId("com.mulesoft.agent").setArtifactId("mule-agent-plugin").setVersion("1.8.0-mule-4.cyborg-SNAPSHOT").setType("zip").build()}).build()).product(Product.MULE_EE).build();
                this.embeddedContainerOptional = Optional.of(embeddedContainer);
                embeddedContainer.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            List<String> args = this.getAllStartupArguments().stream().map(pair -> {
                if (((String)pair.getKey()).equals("debug")) {
                    return "-debug";
                }
                return String.format("-M-D%s=%s", pair.getKey(), pair.getValue());
            }).collect(Collectors.toList());
            this.muleStandaloneController.start(args.toArray(new String[0]), this.getProtocol());
        }
        this.validateAgentIsUpAndRunning();
    }

    protected void validateAgentIsUpAndRunning() {
        new PollingProber(10000L, 100L).check(new Probe(){

            @Override
            public boolean isSatisfied() {
                try {
                    Unirest.setTimeouts((long)100L, (long)1000L);
                    int statusCode = Unirest.get((String)AbstractMuleRuntimeTestCase.this.getAgentApplicationsUrl()).asString().getStatus();
                    return statusCode <= 400;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public String describeFailure() {
                return "could not get a valid agent response";
            }
        });
    }

    private List<ImmutablePair<String, String>> getAllStartupArguments() {
        ArrayList args = Lists.newArrayList(this.defaultMuleStartArguments);
        args.addAll(this.getStartupSystemProperties());
        return args;
    }

    protected String getProtocol() {
        return HTTP;
    }

    @After
    public final void after() {
        if (this.runtimeType.equals((Object)RuntimeType.REMOTE)) {
            if (this.muleStandaloneController.isRunning()) {
                this.muleStandaloneController.stop();
            }
        } else {
            this.embeddedContainerOptional.ifPresent(EmbeddedContainer::stop);
            if (this.systemPropertiesManager != null) {
                this.systemPropertiesManager.unset();
            }
        }
    }

    @AfterClass
    public static void checkDisposedApps() {
        File toolingDir = new File(muleDir + "/tmp/tooling");
        if (toolingDir.exists()) {
            Assert.assertThat((Object)toolingDir.listFiles().length, (Matcher)Matchers.is((Object)0));
        }
    }

    protected List<ImmutablePair<String, String>> getStartupSystemProperties() {
        return Collections.emptyList();
    }

    protected boolean isStartMuleBeforeEachTest() {
        return true;
    }

    public static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while getting URL", e);
        }
    }

    protected void doWithToolingArtifactWithoutDispose(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, Consumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = toolingRuntimeClient.newToolingArtifact(applicationContentUrl);
        consumer.accept(toolingArtifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = toolingRuntimeClient.newToolingArtifact(applicationContentUrl);
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithFetchedToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String id, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = toolingRuntimeClient.fetchToolingArtifact(id);
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    static {
        temporaryFolder = new TemporaryFolder();
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptChecked(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptChecked(T var1) throws Exception;
    }
}

