/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.test.MavenTestUtils;

public final class MavenUtils {
    public static final String MULE_VERSION = "mule.version";
    public static final String MULE_JMS_CONNECTOR_VERSION = "muleJmsConnectorVersion";
    public static final String MUNIT_TOOLS_PLUGIN_VERSION = "munitToolsVersion";
    public static final String MUNIT_RUNNER_PLUGIN_VERSION = "munitRunnerVersion";
    public static final String MULE_EMAIL_CONNECTOR_VERSION = "muleEmailConnectorVersion";
    public static final String MULE_SPRING_MODULE_VERSION = "muleSpringModuleVersion";
    public static final String MULE_DB_CONNECTOR_VERSION = "muleDbConnectorVersion";
    public static final String MULE_FTPS_CONNECTOR_VERSION = "muleFtpsConnectorVersion";
    public static final String MULE_WSC_CONNECTOR_VERSION = "muleWscConnectorVersion";
    public static final String MULE_OBJECTSTORE_CONNECTOR_VERSION = "muleObjectStoreConnectorVersion";
    public static final String MULE_VALIDATION_MODULE_VERSION = "muleValidationModuleVersion";
    public static final String MULE_OAUTH_MODULE_VERSION = "muleOauthModuleVersion";
    public static final String MULE_HTTP_CONNECTOR_VERSION = "muleHttpConnectorVersion";
    public static final String MULE_SOCKETS_CONNECTOR_VERSION = "muleSocketsConnectorVersion";
    public static final String MULE_FILE_CONNECTOR_VERSION = "muleFileConnectorVersion";
    public static final String MULE_FTP_CONNECTOR_VERSION = "muleFtpConnectorVersion";
    public static final String EXTENSION_WITH_METADATA_CONNECTOR_VERSION = "extensionWithMetadataVersion";
    static ClassContextProvider contextClassContextProvider;
    public static final Supplier<File> POM_CONNECTORS_DEPENDENCIES_FINDER;

    public static Supplier<File> pomFromParentOrJar(Class<?> klass) {
        return MavenUtils.pomFromParentOrJar(klass.getProtectionDomain().getCodeSource().getLocation());
    }

    public static String getMuleVersion() {
        String muleVersion = MavenTestUtils.getMavenProperty((String)"tooling.test.mule.version", MavenUtils.pomFromParentOrJar(Thread.currentThread().getContextClassLoader().getResource(".")));
        if (muleVersion != null) {
            return muleVersion;
        }
        return MavenUtils.getToolingVersion();
    }

    public static String getToolingVersion() {
        return MavenTestUtils.getMavenProjectVersion(MavenUtils.pomFromParentOrJar(MavenUtils.class));
    }

    private static Supplier<File> pomFromParentOrJar(URL sourceCodeURL) {
        return () -> {
            try {
                File sourceCodeLocation = new File(sourceCodeURL.toURI());
                if (sourceCodeLocation.isDirectory()) {
                    return sourceCodeLocation.getParentFile().getParentFile().getParentFile();
                }
                return sourceCodeLocation;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private MavenUtils() {
    }

    static {
        AccessController.doPrivileged(() -> {
            contextClassContextProvider = new ClassContextProvider();
            return null;
        });
        POM_CONNECTORS_DEPENDENCIES_FINDER = () -> {
            MavenClientProvider provider = MavenClientProvider.discoverProvider((ClassLoader)Thread.currentThread().getContextClassLoader());
            File repository = (File)provider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier().get();
            String muleDependenciesBomVersion = MavenTestUtils.getMavenProperty((String)"muleDependenciesBomVersion", MavenUtils.pomFromParentOrJar(Thread.currentThread().getContextClassLoader().getResource(".")));
            File bomRoot = new File(repository.getAbsolutePath() + "/com/mulesoft/mule/runtime/bom/mule-test-dependencies-bom/" + muleDependenciesBomVersion);
            File pomFile = new File(bomRoot.getAbsolutePath() + "/mule-test-dependencies-bom-" + muleDependenciesBomVersion + ".pom");
            File asPomXML = new File(bomRoot.getAbsolutePath() + "/pom.xml");
            try {
                if (!asPomXML.exists()) {
                    FileUtils.copyFile((File)pomFile, (File)asPomXML);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bomRoot;
        };
    }

    private static final class ClassContextProvider
    extends SecurityManager {
        private ClassContextProvider() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

