/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mashape.unirest.http.Unirest;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.maven.client.test.MavenTestHelper;
import org.mule.maven.client.test.MavenTestUtils;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.test.RuntimeType;
import org.mule.tooling.client.test.utils.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.utils.MuleStandaloneController;
import org.mule.tooling.client.test.utils.SystemPropertiesManager;
import org.mule.tooling.client.test.utils.probe.PollingProber;
import org.mule.tooling.client.test.utils.probe.Probe;

@RunWith(value=Parameterized.class)
public abstract class AbstractMuleRuntimeTestCase {
    protected static final int DEFAULT_START_TIMEOUT = 50000;
    protected static final int DEFAULT_START_POLL_INTERVAL = 500;
    protected static final int DEFAULT_START_POLL_DELAY = 300;
    protected static final int DEFAULT_CONTROLLER_OPERATION_TIMEOUT = 15000;
    private static final String ORG_MULE_TOOLING = "org.mule.tooling";
    public static final String HTTP = "http";
    private static final String MULESOFT_PUBLIC_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/public/";
    private static final String MULESOFT_PRIVATE_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/private/";
    public static final String RUNTIMES_FOLDER = "runtimes";
    public static final String REST_AGENT_TRANSPORT_PORT_SYS_PROP = "rest.agent.transport.port";
    public static final String MULE_RUNTIME_TOOLING_CLIENT = "mule-runtime-tooling-client";
    public static final String MULE_TOOLING_API_VERSION = "mule.tooling.api.version";
    public static final String MULE_AGENT_VERSION = "mule.agent.version";
    public static final String MULE_VERSION = "mule.version";
    public static final String MULE_JMS_CONNECTOR_VERSION = "muleJmsConnectorVersion";
    public static final String MUNIT_TOOLS_PLUGIN_VERSION = "munitToolsVersion";
    public static final String MUNIT_RUNNER_PLUGIN_VERSION = "munitRunnerVersion";
    public static final String MULE_EMAIL_CONNECTOR_VERSION = "muleEmailConnectorVersion";
    public static final String MULE_SPRING_MODULE_VERSION = "muleSpringModuleVersion";
    public static final String MULE_DB_CONNECTOR_VERSION = "muleDbConnectorVersion";
    public static final String MULE_WSC_CONNECTOR_VERSION = "muleWscConnectorVersion";
    public static final String MULE_OBJECTSTORE_CONNECTOR_VERSION = "muleObjectStoreConnectorVersion";
    public static final String MULE_VALIDATION_MODULE_VERSION = "muleValidationModuleVersion";
    public static final String MULE_HTTP_CONNECTOR_VERSION = "muleHttpConnectorVersion";
    public static final String MULE_SOCKETS_CONNECTOR_VERSION = "muleSocketsConnectorVersion";
    public static final String MULE_FILE_CONNECTOR_VERSION = "muleFileConnectorVersion";
    public static final String MULE_FTP_CONNECTOR_VERSION = "muleFileConnectorVersion";
    public static final String EXTENSION_WITH_METADATA_CONNECTOR_VERSION = "extensionWithMetadataVersion";
    static ClassContextProvider contextClassContextProvider;
    public static final Supplier<File> POM_FOLDER_FINDER;
    protected static String muleDir;
    protected final RuntimeType runtimeType;
    protected MuleStandaloneController muleStandaloneController;
    protected AgentConfiguration defaultAgentConfiguration;
    protected MavenConfiguration defaultMavenConfiguration;
    protected List<ImmutablePair<String, String>> defaultMuleStartArguments;
    protected Optional<EmbeddedContainer> embeddedContainerOptional = Optional.empty();
    private static String muleVersion;
    private static String toolingVersion;
    private SystemPropertiesManager systemPropertiesManager;
    private boolean runtimeStarted = false;
    @ClassRule
    public static TemporaryFolder temporaryFolder;
    @Rule
    public DynamicPort agentPort = new DynamicPort("agentPort");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{RuntimeType.REMOTE}});
    }

    public AbstractMuleRuntimeTestCase(RuntimeType runtimeType) {
        this.runtimeType = runtimeType;
    }

    @Before
    public void before() throws Exception {
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenTestHelper.createDefaultEnterpriseMavenConfigurationBuilder().ignoreArtifactDescriptorRepositories(false);
        settingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        this.defaultMavenConfiguration = mavenConfigurationBuilder.build();
        this.defaultMuleStartArguments = Lists.newArrayList((Object[])new ImmutablePair[]{ImmutablePair.of((Object)REST_AGENT_TRANSPORT_PORT_SYS_PROP, (Object)String.valueOf(this.agentPort.getNumber())), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositoryLocation", (Object)this.defaultMavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath()), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositories.mulesoft-public.url", (Object)MULESOFT_PUBLIC_REPOSITORY), ImmutablePair.of((Object)"muleRuntimeConfig.maven.repositories.mulesoft-private.url", (Object)MULESOFT_PRIVATE_REPOSITORY), ImmutablePair.of((Object)"mule.testingMode", (Object)"true")});
        for (Map.Entry<Object, Object> sysPropEntry : System.getProperties().entrySet()) {
            String key = (String)sysPropEntry.getKey();
            String value = (String)sysPropEntry.getValue();
            if (!key.startsWith("-M")) continue;
            this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)key.replace("-M-D", ""), (Object)value));
        }
        this.defaultMavenConfiguration.getUserSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"muleRuntimeConfig.maven.userSettingsLocation", (Object)file.getAbsolutePath())));
        this.defaultMavenConfiguration.getSettingsSecurityLocation().ifPresent(file -> this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"muleRuntimeConfig.maven.settingsSecurityLocation", (Object)file.getAbsolutePath())));
        this.defaultMavenConfiguration.getGlobalSettingsLocation().ifPresent(file -> this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"muleRuntimeConfig.maven.globalSettingsLocation", (Object)file.getAbsolutePath())));
        if (Boolean.valueOf(System.getProperty("muleRuntime.debug.enabled")).booleanValue()) {
            this.defaultMuleStartArguments.add((ImmutablePair<String, String>)ImmutablePair.of((Object)"debug", (Object)""));
        }
        this.defaultAgentConfiguration = this.newDefaultAgentConfigurationBuilder().build();
        if (this.runtimeType.equals((Object)RuntimeType.REMOTE)) {
            if (muleDir == null) {
                File targetFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
                File runtimesFolder = new File(targetFolder, RUNTIMES_FOLDER);
                String[] runtimes = runtimesFolder.list((FilenameFilter)new WildcardFileFilter("mule*4.2*SNAPSHOT"));
                if (runtimes.length == 0) {
                    runtimes = runtimesFolder.list((FilenameFilter)new WildcardFileFilter("mule*"));
                }
                Assert.assertThat((Object)runtimes, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
                muleDir = new File(runtimesFolder, runtimes[0]).getAbsolutePath();
            }
            this.cleanUpRemoteServerTlsConfiguration();
            this.muleStandaloneController = new MuleStandaloneController(new File(muleDir), new MuleStandaloneConfiguration(50000L, 500L, 300L, 15000L));
        } else if (this.runtimeType.equals((Object)RuntimeType.EMBEDDED)) {
            this.systemPropertiesManager = new SystemPropertiesManager((List<ImmutablePair<String, String>>)ImmutableList.builder().add((Object)ImmutablePair.of((Object)"mule.testingMode", (Object)"true")).add((Object)ImmutablePair.of((Object)"org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", (Object)"org.glassfish.grizzly.memory.HeapMemoryManager")).addAll(this.getAllStartupArguments()).build());
        }
        if (this.isStartMuleBeforeEachTest()) {
            this.startMuleRuntime();
        }
    }

    protected AgentConfiguration.Builder newDefaultAgentConfigurationBuilder() throws URISyntaxException {
        return AgentConfiguration.builder().withDefaultConnectionTimeout(6000L).withDefaultReadTimeout(60000L).withMuleVersion(AbstractMuleRuntimeTestCase.getMuleVersion()).withToolingApiUrl(AbstractMuleRuntimeTestCase.toUrl(new URI(this.getAgentToolingUrl())));
    }

    protected String getAgentUrl() {
        try {
            String localhost = InetAddress.getLocalHost().getHostAddress();
            return "http://" + localhost + ":" + this.agentPort.getNumber();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAgentToolingUrl() {
        try {
            return this.getAgentUrl() + "/mule/tooling";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAgentApplicationsUrl() {
        try {
            return this.getAgentUrl() + "/mule/applications";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void cleanUpRemoteServerTlsConfiguration() {
        File confFolder = new File(muleDir, "conf");
        FileUtils.deleteQuietly((File)new File(confFolder, "mule-agent-default.yml"));
        FileUtils.deleteQuietly((File)new File(confFolder, "mule-agent.yml"));
    }

    public static URI getTestLog4JConfigurationFile() {
        try {
            return AbstractMuleRuntimeTestCase.class.getClassLoader().getResource("log4j2-tooling.xml").toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot find log4j default configuration file", e);
        }
    }

    public static String getMuleVersion() {
        if (muleVersion == null) {
            muleVersion = MavenTestUtils.getMavenProperty((String)"tooling.test.mule.version", POM_FOLDER_FINDER);
            if (muleVersion != null) {
                return muleVersion;
            }
            muleVersion = toolingVersion;
        }
        return muleVersion;
    }

    public static String getToolingVersion() {
        if (toolingVersion == null) {
            toolingVersion = MavenTestUtils.getMavenProjectVersion(POM_FOLDER_FINDER);
        }
        return toolingVersion;
    }

    protected void startMuleRuntime() {
        if (this.runtimeType.equals((Object)RuntimeType.NONE)) {
            return;
        }
        if (this.runtimeStarted) {
            throw new RuntimeException("Runtime already started");
        }
        this.runtimeStarted = true;
        if (this.runtimeType.equals((Object)RuntimeType.EMBEDDED)) {
            try {
                this.systemPropertiesManager.set();
                EmbeddedContainer embeddedContainer = EmbeddedContainer.builder().muleVersion(AbstractMuleRuntimeTestCase.getMuleVersion()).log4jConfigurationFile(AbstractMuleRuntimeTestCase.getTestLog4JConfigurationFile()).mavenConfiguration(this.defaultMavenConfiguration).containerConfiguration(ContainerConfiguration.builder().containerFolder(temporaryFolder.newFolder()).serverPlugins(new BundleDescriptor[]{new BundleDescriptor.Builder().setGroupId("com.mulesoft.agent").setArtifactId("mule-agent-plugin").setVersion(MavenTestUtils.getMavenProperty((String)MULE_AGENT_VERSION, POM_FOLDER_FINDER)).setClassifier("mule-server-plugin").build()}).build()).product(Product.MULE_EE).build();
                this.embeddedContainerOptional = Optional.of(embeddedContainer);
                embeddedContainer.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            List<String> args = this.getAllStartupArguments().stream().map(pair -> {
                if (((String)pair.getKey()).equals("debug")) {
                    return "-debug";
                }
                return String.format("-M-D%s=%s", pair.getKey(), pair.getValue());
            }).collect(Collectors.toList());
            this.muleStandaloneController.start(args.toArray(new String[0]), this.getProtocol());
        }
        this.validateAgentIsUpAndRunning();
    }

    protected void validateAgentIsUpAndRunning() {
        new PollingProber(10000L, 100L).check(new Probe(){

            @Override
            public boolean isSatisfied() {
                try {
                    Unirest.setTimeouts((long)100L, (long)1000L);
                    int statusCode = Unirest.get((String)AbstractMuleRuntimeTestCase.this.getAgentApplicationsUrl()).asString().getStatus();
                    return statusCode <= 400;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public String describeFailure() {
                return "could not get a valid agent response";
            }
        });
    }

    private List<ImmutablePair<String, String>> getAllStartupArguments() {
        ArrayList args = Lists.newArrayList(this.defaultMuleStartArguments);
        args.addAll(this.getStartupSystemProperties());
        return args;
    }

    protected String getProtocol() {
        return HTTP;
    }

    @After
    public final void after() {
        if (this.runtimeType.equals((Object)RuntimeType.REMOTE)) {
            if (this.muleStandaloneController.isRunning()) {
                this.muleStandaloneController.stop();
            }
        } else {
            this.embeddedContainerOptional.ifPresent(EmbeddedContainer::stop);
            if (this.systemPropertiesManager != null) {
                this.systemPropertiesManager.unset();
            }
        }
    }

    @AfterClass
    public static void checkDisposedApps() {
        File toolingDir = new File(muleDir + "/tmp/tooling");
        if (toolingDir.exists()) {
            Assert.assertThat((Object)toolingDir.listFiles().length, (Matcher)Matchers.is((Object)0));
        }
    }

    protected List<ImmutablePair<String, String>> getStartupSystemProperties() {
        return Collections.emptyList();
    }

    protected boolean isStartMuleBeforeEachTest() {
        return true;
    }

    public static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while getting URL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, Map<String, String> artifactProperties, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = toolingRuntimeClient.newToolingArtifact(applicationContentUrl, artifactProperties);
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, applicationContentUrl, Collections.emptyMap(), consumer);
    }

    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, ToolingArtifact parent, CheckedConsumer<ToolingArtifact> consumer) {
        this.doWithToolingArtifact(toolingRuntimeClient, applicationContentUrl, parent, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, URL applicationContentUrl, Map<String, String> artifactProperties, ToolingArtifact parent, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = toolingRuntimeClient.newToolingArtifact(applicationContentUrl, artifactProperties, parent.getId());
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithFetchedToolingArtifact(ToolingRuntimeClient toolingRuntimeClient, String id, CheckedConsumer<ToolingArtifact> consumer) {
        ToolingArtifact toolingArtifact = null;
        try {
            toolingArtifact = toolingRuntimeClient.fetchToolingArtifact(id);
            consumer.accept(toolingArtifact);
        }
        finally {
            if (toolingArtifact != null) {
                toolingArtifact.dispose();
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                contextClassContextProvider = new ClassContextProvider();
                return null;
            }
        });
        POM_FOLDER_FINDER = () -> {
            try {
                Class<?>[] classContext = contextClassContextProvider.getClassContext();
                Class<?> firstToolingClass = null;
                for (int i = classContext.length - 1; i >= 0 && firstToolingClass == null; --i) {
                    Class<?> aClass = classContext[i];
                    if (!aClass.getPackage().getName().startsWith(ORG_MULE_TOOLING)) continue;
                    firstToolingClass = aClass;
                }
                if (firstToolingClass == null) {
                    throw new IllegalStateException("Couldn't find pom for resolving Mule version and Tooling version");
                }
                File sourceCodeLocation = new File(firstToolingClass.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (sourceCodeLocation.isDirectory()) {
                    return sourceCodeLocation.getParentFile().getParentFile().getParentFile();
                }
                return sourceCodeLocation;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        };
        muleDir = System.getProperty("MULE_HOME");
        temporaryFolder = new TemporaryFolder();
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptChecked(t);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void acceptChecked(T var1) throws Exception;
    }

    static final class ClassContextProvider
    extends SecurityManager {
        ClassContextProvider() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

