/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.utils.probe;

import org.mule.tooling.client.test.utils.probe.Probe;
import org.mule.tooling.client.test.utils.probe.Prober;
import org.mule.tooling.client.test.utils.probe.Timeout;

public class PollingProber
implements Prober {
    public static final long DEFAULT_TIMEOUT = 1000L;
    public static final long DEFAULT_POLLING_INTERVAL = 100L;
    private final long timeoutMillis;
    private final long pollDelayMillis;

    public PollingProber() {
        this(1000L, 100L);
    }

    public PollingProber(long timeoutMillis, long pollDelayMillis) {
        this.timeoutMillis = timeoutMillis;
        this.pollDelayMillis = pollDelayMillis;
    }

    @Override
    public void check(Probe probe) {
        if (!this.poll(probe)) {
            throw new AssertionError((Object)probe.describeFailure());
        }
    }

    private boolean poll(Probe probe) {
        Timeout timeout = new Timeout(this.timeoutMillis);
        while (!probe.isSatisfied()) {
            if (timeout.hasTimedOut()) {
                return false;
            }
            this.waitFor(this.pollDelayMillis);
        }
        return true;
    }

    private void waitFor(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected interrupt", e);
        }
    }
}

