/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test;

/**
 * Defines the Mule and Tooling versions to use for creating the Bootstrap
 */
public class BootstrapVersionConfiguration {

  private final String muleVersion;
  private final String toolingVersion;

  public BootstrapVersionConfiguration(String version) {
    this(version, version);
  }

  public BootstrapVersionConfiguration(String toolingVersion, String muleVersion) {
    this.muleVersion = muleVersion;
    this.toolingVersion = toolingVersion;
  }

  public String getMuleVersion() {
    return muleVersion;
  }

  public String getToolingVersion() {
    return toolingVersion;
  }
}
