/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.junit4.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation to be used in a static method that returns the arguments to configure when starting the Mule Runtime Expected method
 * signature is:
 * 
 * <pre>
 * 
 * static List<String> methodName();
 * </pre>
 *
 * @since 4.5
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface RuntimeStartupArgs {
}
