/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.junit4.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation to be used in a static field of the test class. The field annotated with this annotation will be injected with the
 * muleVersion of the Mule Runtime to be started.
 *
 * <pre>
 *  static {@link String} fieldName;
 * </pre>
 *
 * @since 4.5
 */
@Retention(RUNTIME)
@Target(FIELD)
public @interface MuleVersion {
}
