/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.utils;

import static java.lang.Thread.currentThread;
import static org.apache.commons.io.FileUtils.copyFile;
import static org.mule.maven.client.api.MavenClientProvider.discoverProvider;
import static org.mule.maven.client.test.MavenTestUtils.getMavenProjectVersion;
import static org.mule.maven.client.test.MavenTestUtils.getMavenProperty;

import org.mule.maven.client.api.MavenClientProvider;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Supplier;

public final class MavenUtils {

  public static final String MULE_VERSION = "mule.version";
  public static final String MULE_JMS_CONNECTOR_VERSION = "muleJmsConnectorVersion";
  public static final String MUNIT_TOOLS_PLUGIN_VERSION = "munitToolsVersion";
  public static final String MUNIT_RUNNER_PLUGIN_VERSION = "munitRunnerVersion";
  public static final String MULE_EMAIL_CONNECTOR_VERSION = "muleEmailConnectorVersion";
  public static final String MULE_SPRING_MODULE_VERSION = "muleSpringModuleVersion";
  public static final String MULE_DB_CONNECTOR_VERSION = "muleDbConnectorVersion";
  public static final String MULE_FTPS_CONNECTOR_VERSION = "muleFtpsConnectorVersion";
  public static final String MULE_WSC_CONNECTOR_VERSION = "muleWscConnectorVersion";
  public static final String MULE_OBJECTSTORE_CONNECTOR_VERSION = "muleObjectStoreConnectorVersion";
  public static final String MULE_VALIDATION_MODULE_VERSION = "muleValidationModuleVersion";
  public static final String MULE_OAUTH_MODULE_VERSION = "muleOauthModuleVersion";
  public static final String MULE_HTTP_CONNECTOR_VERSION = "muleHttpConnectorVersion";
  public static final String MULE_SOCKETS_CONNECTOR_VERSION = "muleSocketsConnectorVersion";
  public static final String MULE_FILE_CONNECTOR_VERSION = "muleFileConnectorVersion";
  public static final String MULE_FTP_CONNECTOR_VERSION = "muleFtpConnectorVersion";
  public static final String EXTENSION_WITH_METADATA_CONNECTOR_VERSION = "extensionWithMetadataVersion";

  private static final class ClassContextProvider extends SecurityManager {

    @Override
    public Class<?>[] getClassContext() {
      return super.getClassContext();
    }
  }

  static ClassContextProvider contextClassContextProvider;

  static {
    AccessController.doPrivileged((PrivilegedAction<Void>) () -> {
      contextClassContextProvider = new ClassContextProvider();
      return null;
    });
  }

  public static final Supplier<File> POM_CONNECTORS_DEPENDENCIES_FINDER = () -> {
    MavenClientProvider provider = discoverProvider(currentThread().getContextClassLoader());
    File repository = provider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier().get();
    File bomRoot =
        new File(repository.getAbsolutePath() + "/com/mulesoft/mule/runtime/bom/mule-test-dependencies-bom/1.x-SNAPSHOT");
    File pomFile = new File(bomRoot.getAbsolutePath() + "/mule-test-dependencies-bom-1.x-SNAPSHOT.pom");
    File asPomXML = new File(bomRoot.getAbsolutePath() + "/pom.xml");
    try {
      if (!asPomXML.exists()) {
        copyFile(pomFile, asPomXML);
      }
    } catch (IOException e) {

    }
    return bomRoot;
  };

  public static Supplier<File> pomFromParentOrJar(Class<?> klass) {
    return pomFromParentOrJar(klass.getProtectionDomain().getCodeSource().getLocation());
  }

  public static String getMuleVersion() {
    // Use curret thread to look for property since we could be called from a different artifact.
    String muleVersion =
        getMavenProperty("tooling.test.mule.version",
                         pomFromParentOrJar(currentThread().getContextClassLoader().getResource(".")));
    if (muleVersion != null) {
      return muleVersion;
    }
    return getToolingVersion();
  }

  public static String getToolingVersion() {
    // The tooling version is defined by this pom, we can use current class classloader
    return getMavenProjectVersion(pomFromParentOrJar(MavenUtils.class));
  }

  private static Supplier<File> pomFromParentOrJar(URL sourceCodeURL) {
    return () -> {
      try {
        File sourceCodeLocation = new File(sourceCodeURL.toURI());
        if (sourceCodeLocation.isDirectory()) {
          return sourceCodeLocation.getParentFile().getParentFile().getParentFile();
        }
        return sourceCodeLocation;
      } catch (URISyntaxException e) {
        throw new RuntimeException(e);
      }
    };
  }

  private MavenUtils() {}

}
