/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.runtime;

import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.test.MavenTestHelper;
import org.mule.tooling.client.api.extension.model.MuleVersion;
import org.mule.tooling.client.test.runtime.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.runtime.RuntimeAlreadyStartedException;
import org.mule.tooling.client.test.utils.MavenUtils;
import org.mule.tooling.runtime.process.controller.MuleProcessController;
import org.mule.tooling.runtime.process.controller.MuleProcessControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleRuntimeWithAgent {
    private static final String REST_AGENT_TRANSPORT_PORT_SYS_PROP = "-M-Drest.agent.transport.port";
    private static final String AGENT_BASE_URL = "/mule/tooling";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleRuntimeWithAgent.class);
    private final File muleHome;
    private final int agentPort;
    private final String agentProtocol;
    private final MuleStandaloneConfiguration muleStandaloneConfiguration;
    private final List<String> startUpArgs;
    private boolean started = false;
    private final MuleProcessController muleProcessController;

    public static Builder builder() {
        return new Builder();
    }

    private MuleRuntimeWithAgent(File muleHome, MuleStandaloneConfiguration muleStandaloneConfiguration, int agentPort, String agentProtocol, List<String> startupArgs) {
        this.muleHome = muleHome;
        this.muleStandaloneConfiguration = muleStandaloneConfiguration;
        this.agentPort = agentPort;
        this.agentProtocol = agentProtocol;
        this.startUpArgs = startupArgs;
        this.muleProcessController = MuleProcessControllerFactory.createController((File)muleHome, (long)muleStandaloneConfiguration.getControllerOperationTimeout());
    }

    public File getMuleHome() {
        return this.muleHome;
    }

    public synchronized boolean isRunning() {
        return this.started;
    }

    public synchronized void start(List<String> extraStartupArgs) {
        if (this.started) {
            throw new RuntimeAlreadyStartedException("Runtime is already started. It needs to be stopped first to be restarted");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting muleRuntime from: " + this.muleHome);
        }
        ArrayList<String> allStartUpArgs = new ArrayList<String>(this.startUpArgs);
        allStartUpArgs.add("-M-Drest.agent.transport.port=" + this.agentPort);
        allStartUpArgs.addAll(extraStartupArgs);
        System.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("-M")).forEach(p -> allStartUpArgs.add(p.getKey().toString() + (p.getValue() == null ? "" : "=" + p.getValue().toString())));
        if (Boolean.parseBoolean(System.getProperty("muleRuntime.debug.enabled"))) {
            allStartUpArgs.add("-debug");
        }
        try {
            this.muleProcessController.start(allStartUpArgs.toArray(new String[0]));
            this.waitUntilRuntimeIsUpAndRunning();
            this.started = true;
        }
        catch (Exception e2) {
            this.stop();
            throw new IllegalArgumentException("Could not start mule runtime", e2);
        }
    }

    public synchronized void stop() {
        try {
            if (this.muleProcessController != null && this.muleProcessController.isRunning()) {
                this.muleProcessController.stop();
            }
            this.started = false;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop Mule Runtime", e);
        }
    }

    private void waitUntilRuntimeIsUpAndRunning() throws MalformedURLException, UnknownHostException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Waiting for Runtime to be operational...");
        }
        URL agentUrl = new URL(this.agentProtocol, InetAddress.getLocalHost().getHostName(), this.agentPort, AGENT_BASE_URL);
        Awaitility.with().timeout(this.muleStandaloneConfiguration.getStartTimeout() == 0L ? Duration.FOREVER : new Duration(this.muleStandaloneConfiguration.getStartTimeout(), TimeUnit.MILLISECONDS)).pollInterval(this.muleStandaloneConfiguration.getStartPollInterval(), TimeUnit.MILLISECONDS).pollDelay(this.muleStandaloneConfiguration.getStartPollDelay(), TimeUnit.MILLISECONDS).await("Waiting for Remote Tooling Service to be operational").until(() -> {
            URLConnection urlConnection = agentUrl.openConnection();
            urlConnection.setConnectTimeout(200);
            urlConnection.setReadTimeout(200);
            try {
                urlConnection.connect();
                return true;
            }
            catch (Exception e) {
                return HTTPS_PROTOCOL.equals(this.agentProtocol) && e instanceof SSLHandshakeException;
            }
        });
    }

    public static class Builder {
        private static final String AGENT_ARTIFACT_ID = "mule-agent-plugin";
        private static final String AGENT_CONFIG_FILE_NAME = "mule-agent.yml";
        private static final BundleDescriptor.Builder RUNTIME_DISTRO_BUNDLE_DESCRIPTOR_BUILDER = new BundleDescriptor.Builder().setGroupId("com.mulesoft.mule.distributions").setArtifactId("mule-ee-distribution-standalone").setType("tar.gz");
        private static final BundleDescriptor.Builder AGENT_BUNDLE_DESCRIPTOR_BUILDER = new BundleDescriptor.Builder().setGroupId("com.mulesoft.agent").setArtifactId("mule-agent-plugin").setClassifier("mule-server-plugin");
        private static final BundleDescriptor TOOLING_AGENT_PLUGIN_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.tooling").setArtifactId("tooling-agent-plugin").setVersion(MavenUtils.getToolingVersion()).build();
        private String muleVersion;
        private String agentVersion;
        private Integer agentPort;
        private String agentProtocol = "http";
        private MavenConfiguration mavenConfiguration;
        private MuleStandaloneConfiguration muleStandaloneConfiguration = new MuleStandaloneConfiguration(50000L, 500L, 300L, 15000L);
        private File baseDir;
        private List<String> muleStartupArguments = new ArrayList<String>();

        private Builder() {
        }

        public Builder withAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public Builder withAgentPort(int agentPort) {
            this.agentPort = agentPort;
            return this;
        }

        public Builder withAgentProtocol(String protocol) {
            this.agentProtocol = protocol;
            return this;
        }

        public Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
            this.mavenConfiguration = mavenConfiguration;
            return this;
        }

        public Builder withStandaloneConfiguration(MuleStandaloneConfiguration configuration) {
            this.muleStandaloneConfiguration = configuration;
            return this;
        }

        public Builder withMuleVersion(String muleVersion) {
            this.muleVersion = muleVersion;
            return this;
        }

        public Builder withBaseDirectory(File baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder withRuntimeStartupArg(String arg) {
            this.muleStartupArguments.add(arg);
            return this;
        }

        public Builder withRuntimeStartupArg(String key, String value) {
            return this.withRuntimeStartupArg(String.format("%s=%s", key, value));
        }

        public MuleRuntimeWithAgent build() throws RuntimeAlreadyStartedException {
            File muleHome;
            Objects.requireNonNull(this.agentVersion, "agentVersion cannot be null");
            Objects.requireNonNull(this.muleVersion, "muleVersion cannot be null");
            Objects.requireNonNull(this.agentPort, "agentPort cannot be null");
            Objects.requireNonNull(this.mavenConfiguration, "mavenConfiguration cannot be null");
            if (this.baseDir == null) {
                this.baseDir = Files.createTempDir();
            }
            try {
                MavenClient mavenClient = MavenClientProvider.discoverProvider((ClassLoader)Thread.currentThread().getContextClassLoader()).createMavenClient(MavenTestHelper.createDefaultEnterpriseMavenConfigurationBuilder().build());
                BundleDependency distroBundleDependency = mavenClient.resolveBundleDescriptor(RUNTIME_DISTRO_BUNDLE_DESCRIPTOR_BUILDER.setVersion(this.muleVersion).build());
                BundleDependency agentBundleDependency = mavenClient.resolveBundleDescriptor(AGENT_BUNDLE_DESCRIPTOR_BUILDER.setVersion(this.agentVersion).build());
                File distroTarGzFile = new File(distroBundleDependency.getBundleUri());
                File extractedDistroParentFolder = Files.createTempDir();
                TarGZipUnArchiver tarGzipUnarchiver = new TarGZipUnArchiver();
                tarGzipUnarchiver.enableLogging((org.codehaus.plexus.logging.Logger)new ConsoleLogger());
                tarGzipUnarchiver.setSourceFile(distroTarGzFile);
                tarGzipUnarchiver.setDestDirectory(extractedDistroParentFolder);
                tarGzipUnarchiver.extract();
                File runtimesFolder = new File(this.baseDir, "runtimes");
                File extractedDistroFolder = new File(runtimesFolder, this.muleVersion);
                FileUtils.deleteDirectory((File)extractedDistroFolder);
                FileUtils.copyDirectory((File)extractedDistroParentFolder.listFiles()[0], (File)extractedDistroFolder);
                FileUtils.deleteDirectory((File)extractedDistroParentFolder);
                File agentPluginFile = new File(agentBundleDependency.getBundleUri());
                File extractedDistroServerPlugins = new File(extractedDistroFolder, "server-plugins");
                File extractedAgentPluginFolder = new File(extractedDistroServerPlugins, String.join((CharSequence)"-", AGENT_ARTIFACT_ID, this.agentVersion));
                extractedAgentPluginFolder.mkdir();
                ZipUnArchiver zipUnArchiver = new ZipUnArchiver();
                zipUnArchiver.enableLogging((org.codehaus.plexus.logging.Logger)new ConsoleLogger());
                zipUnArchiver.setSourceFile(agentPluginFile);
                zipUnArchiver.setDestDirectory(extractedAgentPluginFolder);
                zipUnArchiver.extract();
                InputStream agentDefaultConfigInputStream = this.getClass().getClassLoader().getResourceAsStream("descriptors/mule-agent.yml");
                File agentConfigTargetFolder = new File(extractedDistroFolder, "conf");
                File agentConfigTargetFile = new File(agentConfigTargetFolder, AGENT_CONFIG_FILE_NAME);
                FileUtils.copyInputStreamToFile((InputStream)agentDefaultConfigInputStream, (File)agentConfigTargetFile);
                if (new MuleVersion(new MuleVersion(this.muleVersion).toCompleteNumericVersion()).atLeast("4.4.0")) {
                    BundleDependency toolingAgentPluginBundleDependency = mavenClient.resolveBundleDescriptor(TOOLING_AGENT_PLUGIN_BUNDLE_DESCRIPTOR);
                    File agentPluginsFolder = new File(extractedAgentPluginFolder, "lib");
                    File toolingAgentPluginFile = new File(toolingAgentPluginBundleDependency.getBundleUri());
                    FileUtils.copyFile((File)toolingAgentPluginFile, (File)new File(agentPluginsFolder, toolingAgentPluginFile.getName()));
                }
                File muleBinFolder = new File(extractedDistroFolder, "bin");
                Arrays.stream(muleBinFolder.listFiles()).forEach(f -> f.setExecutable(true));
                muleHome = extractedDistroFolder;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate Runtime Distribution correctly", e);
            }
            this.withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.repositoryLocation", this.mavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath());
            this.mavenConfiguration.getUserSettingsLocation().ifPresent(loc -> this.withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.userSettingsLocation", loc.getAbsolutePath()));
            this.mavenConfiguration.getSettingsSecurityLocation().ifPresent(loc -> this.withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.settingsSecurityLocation", loc.getAbsolutePath()));
            this.mavenConfiguration.getGlobalSettingsLocation().ifPresent(loc -> this.withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.globalSettingsLocation", loc.getAbsolutePath()));
            return new MuleRuntimeWithAgent(muleHome, this.muleStandaloneConfiguration, this.agentPort, this.agentProtocol, this.muleStartupArguments);
        }
    }
}

