/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.junit4.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.tooling.client.test.BootstrapVersionConfiguration;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.List;

/**
 * Annotation used for defining the {@link List} of {@link BootstrapVersionConfiguration} to be used for running the test.
 * <p/>
 * The signature required for the method is:
 *
 * <pre>
 *   static {@link List} methodName();
 * </pre>
 * <p/>
 *
 * @since 4.5
 */
@Retention(RUNTIME)
@Target({METHOD})
public @interface BootstrapVersions {
}
