/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.utils;

import java.util.function.Consumer;

import com.google.common.base.Throwables;

@FunctionalInterface
public interface CheckedConsumer<T> extends Consumer<T> {

  @Override
  default void accept(T t) {
    try {
      acceptChecked(t);
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }

  void acceptChecked(T t) throws Exception;
}
