/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.test.junit4.annotations;


import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used for defining and injecting the {@link String} used as connection protocol by the Agent Plugin in the Mule
 * Runtime.
 * <p/>
 * When used in a static method, it will be called for generating the {@link String} to be used The signature required for the
 * method is:
 * 
 * <pre>
 *   static {@link String} methodName();
 * </pre>
 * <p/>
 * When used in a static field, the generated value will be injected for the test class to use. Expected field definition is:
 * 
 * <pre>
 *   static {@link String} fieldName;
 * </pre>
 * <p/>
 *
 * @since 4.5
 */
@Retention(RUNTIME)
@Target({METHOD, FIELD})
public @interface AgentProtocol {

}
