/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public final class JunitStaticUtils {
    private JunitStaticUtils() {
    }

    static <T> T getConfiguredValueOrFail(TestClass testClass, Class<? extends Annotation> methodAnnotation, Class<T> expectedReturnType) throws NoSuchMethodException {
        return JunitStaticUtils.getConfiguredValue(testClass, methodAnnotation, expectedReturnType).orElseThrow(() -> new NoSuchMethodException("Missing method annotated with: " + methodAnnotation.getName()));
    }

    static <T> Optional<T> getConfiguredValue(TestClass testClass, Class<? extends Annotation> methodAnnotation, Class<T> expectedReturnType) {
        return JunitStaticUtils.validatedSingleStaticAnnotatedNoArgsMethod(testClass, methodAnnotation, expectedReturnType).map(m -> JunitStaticUtils.invokeStaticSafely(m));
    }

    static <T> void setFieldsIfPresent(TestClass testClass, Class<? extends Annotation> annotation, Class<T> fieldType, T value) {
        JunitStaticUtils.validatedStaticAnnotatedFields(testClass, annotation, fieldType).forEach(f -> JunitStaticUtils.setStaticSafely(f, value));
    }

    private static Object invokeStaticSafely(FrameworkMethod method) {
        try {
            method.getMethod().setAccessible(true);
            return method.invokeExplosively(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Optional<FrameworkMethod> validatedSingleStaticAnnotatedNoArgsMethod(TestClass testClass, Class<? extends Annotation> annotation, Class<?> expectedReturnType) {
        List annotatedMethods = testClass.getAnnotatedMethods(annotation);
        if (annotatedMethods.size() > 1 && ((FrameworkMethod)annotatedMethods.get(0)).getDeclaringClass().equals(((FrameworkMethod)annotatedMethods.get(1)).getDeclaringClass())) {
            throw new IllegalArgumentException("There are multiple methods annotated with " + annotation.getName() + " in: " + ((FrameworkMethod)annotatedMethods.get(0)).getDeclaringClass());
        }
        FrameworkMethod singleMethod = null;
        if (annotatedMethods.size() >= 1) {
            singleMethod = (FrameworkMethod)annotatedMethods.get(0);
            Class returnType = singleMethod.getReturnType();
            StringBuilder errorString = new StringBuilder("Method: " + singleMethod.getName() + " in class: " + singleMethod.getDeclaringClass() + ", annotated with " + annotation.getName() + ":");
            boolean error = false;
            if (!expectedReturnType.isAssignableFrom(returnType)) {
                error = true;
                errorString.append(System.lineSeparator()).append("should return a ").append(expectedReturnType.getName());
            }
            if (!singleMethod.isStatic()) {
                error = true;
                errorString.append(System.lineSeparator()).append("should be static");
            }
            if (singleMethod.getMethod().getParameterTypes().length != 0) {
                error = true;
                errorString.append(System.lineSeparator()).append("should not expect any argument");
            }
            if (error) {
                throw new IllegalArgumentException(errorString.toString());
            }
        }
        return Optional.ofNullable(singleMethod);
    }

    private static void setStaticSafely(FrameworkField field, Object value) {
        try {
            Field javaField = field.getField();
            javaField.setAccessible(true);
            javaField.set(null, value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static List<FrameworkField> validatedStaticAnnotatedFields(TestClass testClass, Class<? extends Annotation> annotation, Class<?> expectedFieldType) {
        return testClass.getAnnotatedFields(annotation).stream().peek(singleField -> {
            Class fieldType = singleField.getType();
            StringBuilder errorString = new StringBuilder("Field: " + singleField.getName() + " in class: " + singleField.getDeclaringClass() + ", annotated with " + annotation.getName() + ":");
            boolean error = false;
            if (!expectedFieldType.isAssignableFrom(fieldType)) {
                error = true;
                errorString.append(System.lineSeparator()).append("should be of type ").append(expectedFieldType.getName());
            }
            if (!singleField.isStatic()) {
                error = true;
                errorString.append(System.lineSeparator()).append("should be static");
            }
            if (error) {
                throw new IllegalArgumentException(errorString.toString());
            }
        }).collect(Collectors.toList());
    }
}

