/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.test.junit4;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.test.MavenTestUtils;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.client.test.BootstrapVersionConfiguration;
import org.mule.tooling.client.test.junit4.JunitStaticUtils;
import org.mule.tooling.client.test.junit4.annotations.AgentPort;
import org.mule.tooling.client.test.junit4.annotations.AgentProtocol;
import org.mule.tooling.client.test.junit4.annotations.BootstrapVersions;
import org.mule.tooling.client.test.junit4.annotations.Log4JConfiguration;
import org.mule.tooling.client.test.junit4.annotations.MuleHome;
import org.mule.tooling.client.test.junit4.annotations.MuleVersion;
import org.mule.tooling.client.test.junit4.annotations.NeedsRuntime;
import org.mule.tooling.client.test.junit4.annotations.RuntimeMavenConfiguration;
import org.mule.tooling.client.test.junit4.annotations.RuntimeStartupArgs;
import org.mule.tooling.client.test.junit4.annotations.ToolingRuntimeBootstrap;
import org.mule.tooling.client.test.runtime.MuleRuntimeWithAgent;
import org.mule.tooling.client.test.runtime.MuleStandaloneConfiguration;
import org.mule.tooling.client.test.utils.MavenUtils;

public class ToolingJUnitTestRunner
extends Suite {
    private static final String MULESOFT_PUBLIC_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/public/";
    private static final String MULESOFT_PRIVATE_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/private/";
    private static final String MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2/";
    private static final String MULE_TOOLING_APPS = "/.mule/tooling/apps";
    private static final String AGENT_VERSION = MavenTestUtils.getMavenProperty((String)"mule.agent.version", MavenUtils.pomFromParentOrJar(ToolingJUnitTestRunner.class));
    private static final String JAVA_VERSION = System.getProperty("java.specification.version");
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final List<Runner> runners;

    public ToolingJUnitTestRunner(Class<?> clazz) throws Throwable {
        super(clazz, NO_RUNNERS);
        this.runners = this.getRunners(clazz);
    }

    private List<Runner> getRunners(Class<?> clazz) throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<Runner> runners = new ArrayList<Runner>();
        List bootstrapVersions = JunitStaticUtils.getConfiguredValueOrFail(this.getTestClass(), BootstrapVersions.class, List.class);
        if (bootstrapVersions.isEmpty()) {
            throw new IllegalArgumentException(BootstrapVersions.class + " annotated method can't return an empty list");
        }
        for (BootstrapVersionConfiguration bootstrapVersion : bootstrapVersions) {
            try {
                this.addRunner(clazz, runners, bootstrapVersion.getMuleVersion(), bootstrapVersion.getToolingVersion(), this.getTestClass().getAnnotation(NeedsRuntime.class) != null);
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
        if (runners.isEmpty()) {
            throw new InitializationError((Throwable)new Exception("No configured test mule runtime"));
        }
        return runners;
    }

    private void addRunner(Class<?> clazz, List<Runner> runners, String muleVersion, String toolingVersion, boolean needsRuntime) throws Exception {
        File targetFolder;
        URL targetLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            targetFolder = new File(targetLocation.toURI()).getParentFile();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not find target folder at: " + targetLocation);
        }
        String testName = ToolingJUnitTestRunner.createTestName(clazz, muleVersion, toolingVersion);
        runners.add((Runner)new SingleRunner(clazz, testName, muleVersion, toolingVersion, targetFolder, needsRuntime));
    }

    private static String createTestName(Class testClass, String muleVersion, String toolingVersion) {
        return "Test: " + testClass.getName() + "Mule-" + muleVersion + "/Tooling-" + toolingVersion;
    }

    private static List<String> getCompatibilityStartupArgs() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (JAVA_VERSION != "1.8") {
            arguments.add("-Wwrapper.java.additional.100=-Dmule.module.tweaking.validation.skip=true");
            arguments.add("-Wwrapper.java.additional.101=--add-opens=java.base/java.lang=ALL-UNNAMED");
            arguments.add("-Wwrapper.java.additional.102=--add-opens=java.base/java.util.concurrent=ALL-UNNAMED");
            arguments.add("-Wwrapper.java.additional.103=--add-exports=com.mulesoft.mule.boot/org.mule.runtime.module.reboot.api=ALL-UNNAMED");
            arguments.add("-Wwrapper.java.additional.104=-Dmule.jvm.version.extension.enforcement=LOOSE");
        }
        return arguments;
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private static class SingleRunner
    extends BlockJUnit4ClassRunner {
        private final String name;
        private final String muleVersion;
        private final String toolingVersion;
        private final File baseDirectory;
        private final boolean needsRuntime;
        private MuleRuntimeWithAgent.Builder muleRuntimeWithAgentBuilder;
        private MuleRuntimeWithAgent muleRuntimeWithAgent;
        private ToolingRuntimeClientBootstrap bootstrap;

        SingleRunner(Class<?> klass, String name, String muleVersion, String toolingVersion, File baseDirectory, boolean needsRuntime) throws InitializationError {
            super(klass);
            this.name = name;
            this.baseDirectory = baseDirectory;
            this.muleVersion = muleVersion;
            this.toolingVersion = toolingVersion;
            this.needsRuntime = needsRuntime;
        }

        private void configureStatic() {
            try {
                String agentProtocol;
                Integer agentPort;
                MavenConfiguration mavenConfiguration = JunitStaticUtils.getConfiguredValueOrFail(this.getTestClass(), RuntimeMavenConfiguration.class, MavenConfiguration.class);
                ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder bootstrapConfigurationBuilder = ToolingRuntimeClientBootstrapConfiguration.builder();
                bootstrapConfigurationBuilder.muleVersion(this.muleVersion);
                bootstrapConfigurationBuilder.toolingVersion(this.toolingVersion);
                JunitStaticUtils.getConfiguredValue(this.getTestClass(), Log4JConfiguration.class, URI.class).ifPresent(arg_0 -> ((ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder)bootstrapConfigurationBuilder).log4jConfiguration(arg_0));
                bootstrapConfigurationBuilder.mavenConfiguration(mavenConfiguration);
                bootstrapConfigurationBuilder.workingFolder(Files.createTempDirectory("workingDir", new FileAttribute[0]).toFile());
                this.bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)bootstrapConfigurationBuilder.build());
                if (this.needsRuntime) {
                    agentPort = JunitStaticUtils.getConfiguredValueOrFail(this.getTestClass(), AgentPort.class, Integer.class);
                    agentProtocol = JunitStaticUtils.getConfiguredValueOrFail(this.getTestClass(), AgentProtocol.class, String.class);
                    this.muleRuntimeWithAgentBuilder = MuleRuntimeWithAgent.builder().withMuleVersion(this.muleVersion).withBaseDirectory(this.baseDirectory).withStandaloneConfiguration(new MuleStandaloneConfiguration(50000L, 500L, 300L, 15000L)).withMavenConfiguration(mavenConfiguration).withAgentVersion(AGENT_VERSION).withAgentPort(agentPort).withAgentProtocol(agentProtocol).withRuntimeStartupArg("-M-Dmule.testingMode", "true").withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.repositories.mulesoft-public.url", ToolingJUnitTestRunner.MULESOFT_PUBLIC_REPOSITORY).withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.repositories.mulesoft-private.url", ToolingJUnitTestRunner.MULESOFT_PRIVATE_REPOSITORY).withRuntimeStartupArg("-M-DmuleRuntimeConfig.maven.repositories.mavenCentral.url", ToolingJUnitTestRunner.MAVEN_CENTRAL);
                } else {
                    agentPort = JunitStaticUtils.getConfiguredValue(this.getTestClass(), AgentPort.class, Integer.class).orElse(null);
                    agentProtocol = JunitStaticUtils.getConfiguredValue(this.getTestClass(), AgentProtocol.class, String.class).orElse(null);
                }
                JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), RuntimeMavenConfiguration.class, MavenConfiguration.class, mavenConfiguration);
                JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), AgentPort.class, Integer.class, agentPort);
                JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), AgentProtocol.class, String.class, agentProtocol);
                JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), ToolingRuntimeBootstrap.class, ToolingRuntimeClientBootstrap.class, this.bootstrap);
                JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), MuleVersion.class, String.class, this.muleVersion);
            }
            catch (IOException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        protected Statement withBeforeClasses(final Statement statement) {
            final List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
            return new Statement(){

                public void evaluate() throws Throwable {
                    this.configureStatic();
                    if (muleRuntimeWithAgentBuilder != null) {
                        muleRuntimeWithAgent = muleRuntimeWithAgentBuilder.build();
                        JunitStaticUtils.setFieldsIfPresent(this.getTestClass(), MuleHome.class, File.class, muleRuntimeWithAgent.getMuleHome());
                    }
                    for (FrameworkMethod method : befores) {
                        method.invokeExplosively(null, new Object[0]);
                    }
                    if (muleRuntimeWithAgent != null) {
                        List extraStartupArgs = ToolingJUnitTestRunner.getCompatibilityStartupArgs();
                        extraStartupArgs.addAll(JunitStaticUtils.getConfiguredValue(this.getTestClass(), RuntimeStartupArgs.class, List.class).orElse(Collections.emptyList()));
                        muleRuntimeWithAgent.start(extraStartupArgs);
                    }
                    statement.evaluate();
                }
            };
        }

        protected Statement withAfterClasses(final Statement statement) {
            final List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    ArrayList<Throwable> errors = new ArrayList<Throwable>();
                    try {
                        statement.evaluate();
                        Thread.sleep(200L);
                        if (bootstrap != null) {
                            bootstrap.dispose();
                        }
                        if (muleRuntimeWithAgent != null) {
                            Object muleHome;
                            File toolingDir;
                            if (muleRuntimeWithAgent.isRunning()) {
                                muleRuntimeWithAgent.stop();
                            }
                            if ((toolingDir = new File((muleHome = muleRuntimeWithAgent.getMuleHome()) + ToolingJUnitTestRunner.MULE_TOOLING_APPS)).exists() && toolingDir.listFiles().length > 0) {
                                throw new RuntimeException("Runtime in: " + muleHome + " was not cleaned up, applications remain");
                            }
                        }
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                    finally {
                        for (FrameworkMethod each : afters) {
                            try {
                                each.invokeExplosively(null, new Object[0]);
                            }
                            catch (Throwable e) {
                                errors.add(e);
                            }
                        }
                    }
                    MultipleFailureException.assertEmpty(errors);
                }
            };
        }

        protected String getName() {
            return "[" + this.name + "]";
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }

        protected Statement classBlock(RunNotifier notifier) {
            return super.classBlock(notifier);
        }
    }
}

