/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.integration.tooling.client;

import static java.lang.String.format;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.client.test.AbstractMuleRuntimeTestCase;
import org.mule.tooling.client.test.RuntimeType;
import org.mule.tooling.client.tests.integration.category.NeedMuleRuntimeTest;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(NeedMuleRuntimeTest.class)
@Feature("DataWeaveServices")
@Story("Integration tests for DataWeave execution and validation using ToolingBootstrap and ToolingRuntimeClient")
public abstract class DataWeaveTestCase extends AbstractMuleRuntimeTestCase {

  protected static final String POJO_APP_LOCATION = "applications/pojo";
  protected static final String POJO_DOMAIN_LOCATION = "domains/pojo-domain";
  protected static final String IMPORT_APP_LOCATION = "applications/import";

  private ToolingRuntimeClientBootstrap bootstrap;

  public DataWeaveTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Before
  public void setUpToolingRuntimeClient() throws Exception {
    bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                      ToolingRuntimeClientBootstrapConfiguration
                                                                                          .builder()
                                                                                          .muleVersion(getMuleVersion())
                                                                                          .toolingVersion(getToolingVersion())
                                                                                          .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                          .workingFolder(temporaryFolder
                                                                                              .newFolder())
                                                                                          .build());
  }

  @After
  public void disposeBootstrap() throws Exception {
    if (bootstrap != null) {
      bootstrap.dispose();
    }
  }

  @Parameterized.Parameters(name = "{0}")
  public static Collection<Object[]> data() {
    return Arrays.asList(new Object[][] {
        {RuntimeType.REMOTE}
    });
  }

  // ****************************************
  // Util methods
  // ****************************************

  protected ToolingRuntimeClient remoteToolingRuntimeClient() throws Exception {
    return bootstrap.getToolingRuntimeClientBuilderFactory().create()
        .withRemoteAgentConfiguration(defaultAgentConfiguration)
        .build();
  }

  protected ToolingRuntimeClient localToolingRuntimeClient() throws Exception {
    return bootstrap.getToolingRuntimeClientBuilderFactory().create()
        .build();
  }

  protected URL getApplicationUrlContent(String appLocationPath) {
    try {
      File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
      File appLocation = new File(targetTestClassesFolder, appLocationPath);
      return appLocation.toURI().toURL();
    } catch (Exception e) {
      throw new IllegalStateException(format("Couldn't get application location as URL for %s", appLocationPath), e);
    }
  }
}
