/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;

import java.util.Optional;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import org.junit.Test;

@Story("Integration tests for custom types DataSense resolution using ToolingBootstrap and ToolingRuntimeClient")
public class DeclarationsDataSenseTestCase extends BaseStaticDataSenseTestCase {

  private static final String APP_LOCATION = "applications/datasense-declarations";

  @Override
  protected String getAppLocation() {
    return APP_LOCATION;
  }

  @Test
  @Description("Checks resolution of DataSense using custom types.")
  public void resolveDataSense() throws Exception {
    newToolingArtifact();

    assertOutputType("new_flow", "%type _:Java = {\n"
        + "  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n"
        + "    \"payload\" : @example(\"value\" : \"{\\\"success\\\":true,\\\"deck_id\\\":\\\"3p40paa87x90\\\",\\\"shuffled\\\":true,\\\"remaining\\\":52}\") @typeAlias(\"value\" : \"ShuffleResult\") {\n"
        + "      \"success\" : Boolean, \n"
        + "      \"deck_id\" : String, \n"
        + "      \"shuffled\" : Boolean, \n"
        + "      \"remaining\" : @typeId(\"value\" : \"int\") Number\n"
        + "    }\n"
        + "  }, \n"
        + "  \"variables\" : {\n"
        + "    \"v1\" : @typeAlias(\"value\" : \"FlatFileType\") @schemaConstruct(\"value\" : STRUCTURE) {\n"
        + "      \"304\" : [{\n"
        + "          \"HDR-RECORD\" : {\n"
        + "            @description(\"value\" : \"HDR-PARTNER\") \"HDR-PARTNER\"? : String, \n"
        + "            @description(\"value\" : \"HDR-SID\") \"HDR-SID\"? : String, \n"
        + "            @description(\"value\" : \"HDR-DOC-TYPE\") \"HDR-DOC-TYPE\"? : String, \n"
        + "            @description(\"value\" : \"HDR-PURPOSE\") \"HDR-PURPOSE\"? : String, \n"
        + "            @description(\"value\" : \"HDR-TRF-SVC-CD\") \"HDR-TRF-SVC-CD\"? : String, \n"
        + "            @description(\"value\" : \"HDR-TYP-SVC\") \"HDR-TYP-SVC\"? : String, \n"
        + "            @description(\"value\" : \"HDR-SCAC\") \"HDR-SCAC\"? : String, \n"
        + "            @description(\"value\" : \"HDR-METH-PAYM\") \"HDR-METH-PAYM\"? : String, \n"
        + "            @description(\"value\" : \"HDR-TOT-EQUIP\") \"HDR-TOT-EQUIP\"? : String, \n"
        + "            @description(\"value\" : \"HDR-AUTH-NAME\") \"HDR-AUTH-NAME\"? : String, \n"
        + "            @description(\"value\" : \"HDR-AUTH-DATE\") \"HDR-AUTH-DATE\"? : String, \n"
        + "            @description(\"value\" : \"HDR-VSSL-CODE\") \"HDR-VSSL-CODE\"? : String, \n"
        + "            @description(\"value\" : \"HDR-VSL-CD-QUAL\") \"HDR-VSL-CD-QUAL\"? : String, \n"
        + "            @description(\"value\" : \"HDR-VSSL-NAME\") \"HDR-VSSL-NAME\"? : String, \n"
        + "            @description(\"value\" : \"HDR-VSSL-FLAG\") \"HDR-VSSL-FLAG\"? : String, \n"
        + "            @description(\"value\" : \"HDR-VOY-NBR\") \"HDR-VOY-NBR\"? : String, \n"
        + "            @description(\"value\" : \"HDR-LTR-CRD-NBR\") \"HDR-LTR-CRD-NBR\"? : String, \n"
        + "            @description(\"value\" : \"HDR-LTR-CRD-DT\") \"HDR-LTR-CRD-DT\"? : String, \n"
        + "            @description(\"value\" : \"HDR-LTR-CRD-EXP\") \"HDR-LTR-CRD-EXP\"? : String, \n"
        + "            @description(\"value\" : \"HDR-ON-BRD-DATE\") \"HDR-ON-BRD-DATE\"? : String, \n"
        + "            @description(\"value\" : \"HDR-BOOKING-NBR\") \"HDR-BOOKING-NBR\"? : String, \n"
        + "            @description(\"value\" : \"HDR-ID\") \"HDR-ID\"? : String, \n"
        + "            @description(\"value\" : \"HDR-R-CNTRY\") \"HDR-R-CNTRY\"? : String, \n"
        + "            @description(\"value\" : \"HDR-L-CNTRY\") \"HDR-L-CNTRY\"? : String, \n"
        + "            @description(\"value\" : \"HRD-FILLER\") \"HRD-FILLER\"? : String\n"
        + "          }, \n"
        + "          \"REF-RECORD\"? : [{\n"
        + "              @description(\"value\" : \"REF-NBR-QUAL\") \"REF-NBR-QUAL\"? : String, \n"
        + "              @description(\"value\" : \"REF-NBR\") \"REF-NBR\"? : String, \n"
        + "              @description(\"value\" : \"REF-NBR-DESC\") \"REF-NBR-DESC\"? : String, \n"
        + "              @description(\"value\" : \"REF-FILLER\") \"REF-FILLER\"? : String\n"
        + "            }], \n"
        + "          \"NAD-RECORD\"? : [{\n"
        + "              @description(\"value\" : \"NAD-PARTY-TYPE\") \"NAD-PARTY-TYPE\"? : String, \n"
        + "              @description(\"value\" : \"NAD-ID-CD-QUAL\") \"NAD-ID-CD-QUAL\"? : String, \n"
        + "              @description(\"value\" : \"NAD-ID-CODE\") \"NAD-ID-CODE\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR1\") \"NAD-NAME-ADDR1\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR2\") \"NAD-NAME-ADDR2\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR3\") \"NAD-NAME-ADDR3\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR4\") \"NAD-NAME-ADDR4\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR5\") \"NAD-NAME-ADDR5\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR6\") \"NAD-NAME-ADDR6\"? : String, \n"
        + "              @description(\"value\" : \"NAD-NAME-ADDR7\") \"NAD-NAME-ADDR7\"? : String, \n"
        + "              @description(\"value\" : \"NAD-CITY\") \"NAD-CITY\"? : String, \n"
        + "              @description(\"value\" : \"NAD-STATE\") \"NAD-STATE\"? : String, \n"
        + "              @description(\"value\" : \"NAD-ZIP\") \"NAD-ZIP\"? : String, \n"
        + "              @description(\"value\" : \"NAD-CNTRY\") \"NAD-CNTRY\"? : String, \n"
        + "              @description(\"value\" : \"NAD-LOC-ID-QUAL\") \"NAD-LOC-ID-QUAL\"? : String, \n"
        + "              @description(\"value\" : \"NAD-LOC-ID\") \"NAD-LOC-ID\"? : String, \n"
        + "              @description(\"value\" : \"NAD-CNTC-FUNCT\") \"NAD-CNTC-FUNCT\"? : String, \n"
        + "              @description(\"value\" : \"NAD-CNTC-NAME\") \"NAD-CNTC-NAME\"? : String, \n"
        + "              @description(\"value\" : \"NAD-COMM-NBR-TP\") \"NAD-COMM-NBR-TP\"? : String, \n"
        + "              @description(\"value\" : \"NAD-COMM-NBR\") \"NAD-COMM-NBR\"? : String, \n"
        + "              @description(\"value\" : \"NAD-FILLER\") \"NAD-FILLER\"? : String\n"
        + "            }]\n"
        + "        }]\n"
        + "    }, \n"
        + "    \"v2\" : @typeAlias(\"value\" : \"CopybookType\") @schemaConstruct(\"value\" : SEGMENT) [{\n"
        + "        @description(\"value\" : \"COMPANY-NAME\") \"COMPANY-NAME\"? : String, \n"
        + "        @description(\"value\" : \"CONTACTS\") \"CONTACTS\"? : {\n"
        + "          @description(\"value\" : \"PRESIDENT\") \"PRESIDENT\"? : {\n"
        + "            @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, \n"
        + "            @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String\n"
        + "          }, \n"
        + "          @description(\"value\" : \"VP-MARKETING\") \"VP-MARKETING\"? : {\n"
        + "            @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, \n"
        + "            @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String\n"
        + "          }, \n"
        + "          @description(\"value\" : \"ALTERNATE-CONTACT\") \"ALTERNATE-CONTACT\"? : {\n"
        + "            @description(\"value\" : \"TITLE\") \"TITLE\"? : String, \n"
        + "            @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, \n"
        + "            @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String\n"
        + "          }\n"
        + "        }, \n"
        + "        @description(\"value\" : \"ADDRESS\") \"ADDRESS\"? : String, \n"
        + "        @description(\"value\" : \"CITY\") \"CITY\"? : String, \n"
        + "        @description(\"value\" : \"STATE\") \"STATE\"? : String, \n"
        + "        @description(\"value\" : \"ZIP\") \"ZIP\"? : @int Number\n"
        + "      }], \n"
        + "    \"v3\" : @typeAlias(\"value\" : \"FixedWidthType\") @schemaConstruct(\"value\" : SEGMENT) [{\n"
        + "        @FieldFormatAnnotation(\"width\" : 1, \"align\" : \"LEFT\") @description(\"value\" : \"TYPE-OF-NAME\") \"TYPE-OF-NAME\"? : String, \n"
        + "        @description(\"value\" : \"CUSTOMER-NAME\") \"CUSTOMER-NAME\"? : {\n"
        + "          @FieldFormatAnnotation(\"width\" : 15, \"align\" : \"LEFT\") @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, \n"
        + "          @FieldFormatAnnotation(\"width\" : 8, \"align\" : \"LEFT\") @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String\n"
        + "        }\n"
        + "      }], \n"
        + "    \"v4\" : @example(\"value\" : \"Col1,Col2\n"
        + "Value1,Value2\n"
        + "\") [{\n"
        + "        \"Col1\" : String, \n"
        + "        \"Col2\" : String\n"
        + "      }], \n"
        + "    \"v5\" : {\n"
        + "      \"Smile You Can Read Me !\" : [{\n"
        + "          \"A\" : String, \n"
        + "          \"B\" : String, \n"
        + "          \"C\" : String, \n"
        + "          \"D\" : String | Number, \n"
        + "          \"E\"? : String | Number\n"
        + "        }]\n"
        + "    }\n"
        + "  }\n"
        + "}");
  }

  @Test
  public void useApplicationTypesFromDependency() throws Exception {
    newToolingArtifact("applications/custom-types-defined-in-dependency");

    assertOutputType("new_flow", "%type _:Java = {\n"
        + "  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n"
        + "    \"payload\" : @typeAlias(\"value\" : \"FixedWidthType\") @schemaConstruct(\"value\" : SEGMENT) [{\n"
        + "        @FieldFormatAnnotation(\"width\" : 1, \"align\" : \"LEFT\") @description(\"value\" : \"TYPE-OF-NAME\") \"TYPE-OF-NAME\"? : String, \n"
        + "        @description(\"value\" : \"CUSTOMER-NAME\") \"CUSTOMER-NAME\"? : {\n"
        + "          @FieldFormatAnnotation(\"width\" : 15, \"align\" : \"LEFT\") @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, \n"
        + "          @FieldFormatAnnotation(\"width\" : 8, \"align\" : \"LEFT\") @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String\n"
        + "        }\n"
        + "      }]\n"
        + "  }, \n"
        + "  \"variables\" : {\n"
        + "\n"
        + "  }\n"
        + "}");

    assertOutputType("setRequestIdVariable", "%type _:Java = {\n"
        + "  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n"
        + "\n"
        + "  }, \n"
        + "  \"variables\" : {\n"
        + "    \"X_REQUEST_ID\" : @example(\"value\" : \"{\\\"success\\\":true,\\\"deck_id\\\":\\\"3p40paa87x90\\\",\\\"shuffled\\\":true,\\\"remaining\\\":52}\") @typeAlias(\"value\" : \"ShuffleResult\") {\n"
        + "      \"success\" : Boolean, \n"
        + "      \"deck_id\" : String, \n"
        + "      \"shuffled\" : Boolean, \n"
        + "      \"remaining\" : @typeId(\"value\" : \"int\") Number\n"
        + "    }\n"
        + "  }\n"
        + "}");
  }

  private void assertOutputType(String flowName, String expectedOutputType) {
    final DataSenseRequest request = getRequest();
    request.setLocation(Location.builder().globalName(flowName).addProcessorsPart().addIndexPart(0).build());
    Optional<DataSenseInfo> result = getToolingArtifact().dataSenseService().resolveDataSense(request);

    final MetadataType outputMetadataType = result.flatMap(DataSenseInfo::getOutput)
        .orElseThrow(() -> new AssertionError("Expected output metadata type not present."));
    final MetadataTypeWriter metadataTypeWriter = new MetadataTypeWriter();
    assertThat(metadataTypeWriter.toString(outputMetadataType), is(expectedOutputType));
  }

}
