/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assume.assumeThat;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import static org.mule.maven.client.test.MavenTestUtils.getMavenProperty;
import static org.mule.tooling.client.api.descriptors.ArtifactDescriptor.newBuilder;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.POM_FOLDER_FINDER;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getMuleVersion;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getTestLog4JConfigurationFile;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getToolingVersion;

import org.mule.tooling.client.tests.integration.category.DoesNotNeedMuleRuntimeTest;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.persistence.ExtensionModelJsonSerializer;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

import java.util.Optional;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(DoesNotNeedMuleRuntimeTest.class)
@Feature("ExtensionModelService")
@Story("Integration tests for ExtensionModelJsonSerializer")
public class ExtensionModelJsonSerializerTestCase {

  private ToolingRuntimeClientBootstrap bootstrap;
  private ToolingRuntimeClient toolingRuntimeClient;
  private static final String MULE_JMS_CONNECTOR_VERSION = "muleJmsConnectorVersion";
  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  @Before
  public void setUpToolingRuntimeClient() throws Exception {
    bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                      ToolingRuntimeClientBootstrapConfiguration
                                                                                          .builder()
                                                                                          .muleVersion(getMuleVersion())
                                                                                          .toolingVersion(getToolingVersion())
                                                                                          .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                          .log4jConfiguration(getTestLog4JConfigurationFile())
                                                                                          .workingFolder(temporaryFolder
                                                                                              .newFolder())
                                                                                          .build());
    toolingRuntimeClient = bootstrap.getToolingRuntimeClientBuilderFactory().create().build();
  }

  @After
  public void disposeBootstrap() throws Exception {
    if (bootstrap != null) {
      bootstrap.dispose();
    }
  }

  @Test
  @Description("Checks Tooling extension model can be serialized and deserialized")
  public void serializeExtensionModel() throws Exception {
    Optional<ExtensionModel> extensionModelOptional = toolingRuntimeClient.extensionModelService()
        .loadExtensionModel(newBuilder()
            .withGroupId("org.mule.connectors")
            .withArtifactId("mule-jms-connector")
            .withClassifier("mule-plugin")
            .withVersion(getMavenProperty(MULE_JMS_CONNECTOR_VERSION, POM_FOLDER_FINDER))
            .build());

    assumeThat(extensionModelOptional.isPresent(), is(true));
    final ExtensionModel extensionModel = extensionModelOptional.get();

    final ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
    String json = extensionModelJsonSerializer.serialize(extensionModel);
    ExtensionModel deserializedExtensionModel = extensionModelJsonSerializer.deserialize(json);

    // Just a simple validation to check that ExtensionModel can be serialized and deserialized
    assertThat(json, is(extensionModelJsonSerializer.serialize(deserializedExtensionModel)));
  }

}
