/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.hamcrest;

import java.io.IOException;

import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.xml.sax.SAXException;

/**
 * Matcher that uses {@link XMLUnit} to compare xmls.
 */
public class IsEquivalentTo extends TypeSafeMatcher<String> {

  private final String expected;
  private final boolean onlySimilar;

  private IsEquivalentTo(String expected) {
    this(expected, false);
  }

  private IsEquivalentTo(String expected, boolean onlySimilar) {
    this.expected = expected;
    this.onlySimilar = onlySimilar;
  }

  @Override
  public boolean matchesSafely(String actual) {
    XMLUnit.setIgnoreAttributeOrder(true);
    XMLUnit.setIgnoreComments(true);
    XMLUnit.setIgnoreDiffBetweenTextAndCDATA(true);
    XMLUnit.setIgnoreWhitespace(true);
    XMLUnit.setNormalize(true);
    XMLUnit.setNormalizeWhitespace(true);
    try {
      if (onlySimilar) {
        return new Diff(expected, actual).similar();
      }
      return new Diff(expected, actual).identical();
    } catch (SAXException e) {
      return false;
    } catch (IOException e) {
      return false;
    }
  }

  public void describeTo(Description description) {
    description.appendText("an XML document equivalent to: " + expected);
  }

  @Factory
  public static Matcher<String> isEquivalentTo(String expected) {
    return new IsEquivalentTo(expected);
  }

  @Factory
  public static Matcher<String> equivalentTo(String expected) {
    return new IsEquivalentTo(expected);
  }

  @Factory
  public static Matcher<String> isSimilarTo(String expected) {
    return new IsEquivalentTo(expected, true);
  }

  @Factory
  public static Matcher<String> similarTo(String expected) {
    return new IsEquivalentTo(expected, true);
  }

}
