/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static java.util.Collections.emptyMap;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getMuleVersion;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getTestLog4JConfigurationFile;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getToolingVersion;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.toUrl;
import org.mule.tooling.client.tests.integration.category.DoesNotNeedMuleRuntimeTest;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

import java.io.File;
import java.util.Map;

import io.qameta.allure.Feature;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(DoesNotNeedMuleRuntimeTest.class)
@Feature("DataSenseService")
public abstract class BaseStaticDataSenseTestCase {

  private ToolingRuntimeClientBootstrap bootstrap;
  private ToolingRuntimeClient toolingRuntimeClient;
  private ToolingArtifact toolingArtifact;
  private DataSenseRequest request;
  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  @Before
  public void setUpToolingRuntimeClient() throws Exception {
    bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                      ToolingRuntimeClientBootstrapConfiguration
                                                                                          .builder()
                                                                                          .muleVersion(getMuleVersion())
                                                                                          .toolingVersion(getToolingVersion())
                                                                                          .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                          .workingFolder(temporaryFolder
                                                                                              .newFolder())
                                                                                          .log4jConfiguration(getTestLog4JConfigurationFile())
                                                                                          .build());
    toolingRuntimeClient = bootstrap.getToolingRuntimeClientBuilderFactory().create()
        .withMavenConfiguration(createDefaultEnterpriseMavenConfiguration())
        .build();
  }


  @After
  public void disposeBootstrap() throws Exception {
    if (bootstrap != null) {
      bootstrap.dispose();
    }
  }

  @Before
  public void setUpRequest() {
    request = createDataSenseRequest();
  }

  protected DataSenseRequest createDataSenseRequest() {
    DataSenseRequest result = new DataSenseRequest();
    return result;
  };

  protected abstract String getAppLocation();

  protected void newToolingArtifact() throws Exception {
    newToolingArtifact(getAppLocation());
  }

  protected void newToolingArtifact(String appLocation) throws Exception {
    newToolingArtifact(appLocation, emptyMap());
  }

  protected void newToolingArtifact(String appLocation, Map<String, String> properties) throws Exception {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File application = new File(targetTestClassesFolder, appLocation);
    toolingArtifact = newToolingArtifact(application, properties);

    assertThat(toolingArtifact, not(nullValue()));
  }

  protected ToolingArtifact newToolingArtifact(File appLocation) throws Exception {
    return newToolingArtifact(appLocation, emptyMap());
  }

  protected ToolingArtifact newToolingArtifact(File appLocation, Map<String, String> properties) throws Exception {
    return toolingRuntimeClient.newToolingArtifact(toUrl(appLocation.toURI()), properties);
  }

  public ToolingRuntimeClientBootstrap getBootstrap() {
    return bootstrap;
  }

  public ToolingRuntimeClient getToolingRuntimeClient() {
    return toolingRuntimeClient;
  }

  public ToolingArtifact getToolingArtifact() {
    return toolingArtifact;
  }

  public DataSenseRequest getRequest() {
    return request;
  }
}
