/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import org.mule.tooling.client.api.datasense.DataSenseNotification;
import org.mule.tooling.client.api.datasense.DataSenseNotificationType;

import java.util.function.Predicate;

import org.hamcrest.TypeSafeMatcher;

/**
 * {@link TypeSafeMatcher} for {@link DataSenseNotification}.
 */
public class DataSenseNotificationMatcher extends TypeSafeMatcher<DataSenseNotification> {

  private final Predicate<DataSenseNotification> predicate;
  private final String name;

  DataSenseNotificationMatcher(Predicate<DataSenseNotification> predicate, String name) {
    super(DataSenseNotification.class);
    this.predicate = predicate;
    this.name = name;
  }

  @Override
  protected boolean matchesSafely(DataSenseNotification object) {
    return predicate.test(object);
  }

  @Override
  protected void describeMismatchSafely(DataSenseNotification item, org.hamcrest.Description mismatchDescription) {
    super.describeMismatchSafely(item, mismatchDescription);
  }

  @Override
  public void describeTo(org.hamcrest.Description description) {
    description.appendText(name);
  }

  public static DataSenseNotificationMatcher notification(Predicate<DataSenseNotification> predicate, String name) {
    return new DataSenseNotificationMatcher(predicate, name);
  }

  public static DataSenseNotificationMatcher notificationTypeIs(DataSenseNotificationType dataSenseNotificationType) {
    return notification(n -> dataSenseNotificationType.equals(n.getNotificationType()), "datasense notification");
  }

  public static DataSenseNotificationMatcher notificationMessageContains(String text) {
    return notification(n -> n.getMessage().getMessage().contains(text), "datasense notification message contains");
  }

}
