/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.integration.tooling.client;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;

public class TestHttpResponseProvider implements HttpResponseProvider {

  private byte[] response;
  private String contentType;
  private int statusCode;

  public void nextRequestRespondWithJson(String jsonResponse) {
    this.response = jsonResponse.getBytes();
    this.contentType = "application/json";
    this.statusCode = 200;
  }

  public void nextRequestRespondOk() {
    this.response = new byte[0];
    this.contentType = "text/plain";
    this.statusCode = 200;
  }

  @Override
  public HttpResponse getResponse(HttpRequest httpRequest) {
    return new HttpResponseImpl(statusCode, contentType, response);
  }

  @Override
  public void verify() throws UnsatisfiedExpectationException {

  }
}
