/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client.datasense;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.client.api.component.location.Location.builder;
import org.mule.tooling.client.tests.integration.tooling.client.BaseDynamicDataSenseTestCase;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.test.RuntimeType;

import java.util.Optional;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature("DataSense")
@Story("MUnit tests for DataSense resolution")
public class MUnitDataSenseTestCase extends BaseDynamicDataSenseTestCase {

  public MUnitDataSenseTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  protected String getAppFile() {
    return "applications/munit/test001";
  }

  @Test
  @Description("Checks DataSense resolution using HTTP")
  public void resolveDataSense() throws Exception {
    final ToolingRuntimeClient toolingRuntimeClient = createToolingRuntimeClient();
    final ToolingArtifact toolingArtifact = newToolingArtifact(toolingRuntimeClient, getAppFile());

    final DataSenseRequest dataSenseRequest =
        createDataSenseRequest(builder().globalName("testSimpleHTTPRequest").addPart("route").addIndexPart(2).addProcessorsPart()
            .addIndexPart(0).build());
    Optional<DataSenseInfo> result = toolingArtifact.dataSenseService().resolveDataSense(dataSenseRequest);
    assertThat(result.isPresent(), is(true));
    result.ifPresent(dataSenseInfo -> {
      final MetadataTypeWriter metadataTypeWriter = new MetadataTypeWriter();
      assertThat(dataSenseInfo.getIncoming().isPresent(), is(true));
      final MetadataType incomingType =
          dataSenseInfo.getIncoming()
              .orElseThrow(() -> new AssertionError("Expected incoming type not present"));
      assertThat(metadataTypeWriter.toString(incomingType),
                 is("%type _:Java = {\n"
                     + "  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n"
                     + "\n"
                     + "  }, \n"
                     + "  \"variables\" : {\n"
                     + "\n"
                     + "  }\n"
                     + "}"));
    });
  }

}
