/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client.metadata;

import static java.lang.String.format;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.client.test.AbstractMuleRuntimeTestCase;
import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.net.URL;

import org.junit.After;
import org.junit.Before;

public abstract class AbstractMetadataCacheTestCase extends AbstractMuleRuntimeTestCase {

  private ToolingRuntimeClientBootstrap bootstrap;

  public AbstractMetadataCacheTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Before
  public void setUpToolingRuntimeClient() throws Exception {
    bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                      ToolingRuntimeClientBootstrapConfiguration
                                                                                          .builder()
                                                                                          .muleVersion(getMuleVersion())
                                                                                          .toolingVersion(getToolingVersion())
                                                                                          .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                          .workingFolder(temporaryFolder
                                                                                              .newFolder())
                                                                                          .build());
  }

  @After
  public void disposeBootstrap() throws Exception {
    if (bootstrap != null) {
      bootstrap.dispose();
    }
  }

  // ****************************************
  // Util methods
  // ****************************************

  protected ToolingRuntimeClient remoteToolingRuntimeClient() throws Exception {
    return bootstrap.getToolingRuntimeClientBuilderFactory().create()
        .withRemoteAgentConfiguration(defaultAgentConfiguration)
        .build();
  }

  protected URL getApplicationUrlContent(String appLocationPath) {
    try {
      File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
      File appLocation = new File(targetTestClassesFolder, appLocationPath);
      return appLocation.toURI().toURL();
    } catch (Exception e) {
      throw new IllegalStateException(format("Couldn't get application location as URL for %s", appLocationPath), e);
    }
  }

}
