/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.junit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines the versions to be used by {@link ToolingJUnitTestRunner} when running the tests.
 *
 * @since 4.1
 */
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(value = ToolingRuntimeClientVersions.class)
@Target(ElementType.TYPE)
public @interface ToolingRuntimeClientVersion {

  /**
   * @return {@link java.io.File} location of the Mule Runtime, relative so it is accessed via classpath.
   */
  String muleHome();

  /**
   * @return {@link String} Tooling Runtime Client version to be bootstrapped.
   */
  String toolingVersion();

  /**
   * @return {@link String} to the log4j configuration to be used by Tooling, the file will be located via classpath.
   */
  String log4Configuration() default "log4j2-tooling.xml";

}
