/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.compatibility;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mule.tooling.client.api.descriptors.ArtifactDescriptor.newBuilder;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.tests.junit.ToolingRuntimeClientBootstrapProvider;

import java.io.File;
import java.util.Optional;

public abstract class FeatureSerializationCompatibililtyTestCase extends AbstractToolingTestCase {

  private static final String MULE_DB_CONNECTOR_TEST_VERSION = "1.0.0";

  public FeatureSerializationCompatibililtyTestCase(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder,
                                                    ToolingRuntimeClientBootstrapProvider toolingRuntimeClientBootstrapProvider,
                                                    File muleHome) {
    super(mavenConfigurationBuilder, toolingRuntimeClientBootstrapProvider, muleHome);
  }

  protected Optional<DisplayModel> getFeatureFromExtensionModel() {
    Optional<ExtensionModel> extensionModelOptional =
        getToolingRuntimeBootstrap().getToolingRuntimeClientBuilderFactory().create().build()
            .extensionModelService().loadExtensionModel(newBuilder()
                .withGroupId("org.mule.connectors")
                .withArtifactId("mule-db-connector")
                .withClassifier("mule-plugin")
                .withVersion(getMuleDbConnectorTestVersion())
                .build());

    assertThat(extensionModelOptional.isPresent(), is(true));
    final ExtensionModel extensionModel = extensionModelOptional.get();
    return extensionModel.getConfigurationModel("config").get().getConnectionProviderModel("generic").get()
        .getParameterGroupModel("Connection").get().getParameterModel("driverClassName").get().getDisplayModel();
  }

  protected String getMuleDbConnectorTestVersion() {
    return MULE_DB_CONNECTOR_TEST_VERSION;
  }

}
