/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.compatibility;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.tests.integration.category.NeedMuleRuntimeTest;
import org.mule.tooling.client.tests.junit.ToolingJUnitTestRunner;
import org.mule.tooling.client.tests.junit.ToolingRuntimeClientBootstrapProvider;
import org.mule.tooling.client.tests.junit.ToolingRuntimeClientVersion;

import java.io.File;
import java.util.Optional;

import io.qameta.allure.Description;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(NeedMuleRuntimeTest.class)
@RunWith(ToolingJUnitTestRunner.class)
@ToolingRuntimeClientVersion(muleHome = "runtimes/mule-enterprise-standalone-4.0.0", toolingVersion = "4.0.3")
public class FeatureSerializationWithTooling400VersionTestCase extends FeatureSerializationCompatibililtyTestCase {

  public FeatureSerializationWithTooling400VersionTestCase(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder,
                                                           ToolingRuntimeClientBootstrapProvider toolingRuntimeClientBootstrapProvider,
                                                           File muleHome) {
    super(mavenConfigurationBuilder, toolingRuntimeClientBootstrapProvider, muleHome);
  }

  @Override
  protected boolean shouldStartMule() {
    return false;
  }

  @Test
  @Description("Test that the new feature is not included in the display model of 4.0.x version")
  public void loadExtensionModel() {
    Optional<DisplayModel> displayModelOptional = getFeatureFromExtensionModel();
    assertThat(displayModelOptional.isPresent(), is(false));
  }

  @Test
  @Description("Validates that new field from 4.1.0 is not enabled as feature when loaded from 4.0.x")
  public void errorModelHandleableFeature() {
    final ExtensionModel extensionModel =
        getToolingRuntimeBootstrap().getToolingRuntimeClientBuilderFactory().create().build().extensionModelService()
            .loadMuleExtensionModels().get(0);
    extensionModel.getErrorModels().stream().forEach(errorModel -> assertThat(errorModel.getHandleable().isEnabled(), is(false)));
  }

}
