/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.compatibility;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.mule.maven.client.test.MavenTestUtils.getMavenProperty;
import static org.mule.tooling.client.api.descriptors.ArtifactDescriptor.newBuilder;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.MULE_DB_CONNECTOR_VERSION;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.POM_FOLDER_FINDER;

import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.extension.model.ClassValueModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.tests.integration.category.NeedMuleRuntimeTest;
import org.mule.tooling.client.tests.junit.ToolingJUnitTestRunner;
import org.mule.tooling.client.tests.junit.ToolingRuntimeClientBootstrapProvider;
import org.mule.tooling.client.tests.junit.ToolingRuntimeClientVersion;

import java.io.File;
import java.util.List;
import java.util.Optional;

import io.qameta.allure.Description;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(NeedMuleRuntimeTest.class)
@RunWith(ToolingJUnitTestRunner.class)
@ToolingRuntimeClientVersion(muleHome = "runtimes/mule-enterprise-standalone-4.2.0-SNAPSHOT", toolingVersion = "4.2.0-SNAPSHOT")
public class FeatureSerializationWithToolingSnapshotToolingVersionTestCase extends FeatureSerializationCompatibililtyTestCase {

  public FeatureSerializationWithToolingSnapshotToolingVersionTestCase(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder,
                                                                       ToolingRuntimeClientBootstrapProvider toolingRuntimeClientBootstrapProvider,
                                                                       File muleHome) {
    super(mavenConfigurationBuilder, toolingRuntimeClientBootstrapProvider, muleHome);
  }

  @Override
  protected boolean shouldStartMule() {
    return false;
  }

  @Test
  @Description("Test that the new feature is included in the display model of newer versions")
  public void loadExtensionModel() {
    Optional<DisplayModel> displayModelOptional = getFeatureFromExtensionModel();
    assertThat(displayModelOptional.isPresent(), is(true));

    Feature<Optional<ClassValueModel>> featuredClassValueModel = displayModelOptional.get().getClassValueModel();

    assertThat(featuredClassValueModel.isEnabled(), is(true));
    assertThat(featuredClassValueModel.get().isPresent(), is(true));
    List<String> assignedFrom = featuredClassValueModel.get().get().getAssignableFrom();
    assertThat(assignedFrom, hasSize(1));
    assertThat(assignedFrom.get(0), is("java.sql.Driver"));
  }

  @Test
  @Description("Test that the new feature is included in the display model of newer versions")
  public void metadataKeyResolverCategoryNameFeature() {
    final ExtensionModel extensionModel = getToolingRuntimeBootstrap()
        .getToolingRuntimeClientBuilderFactory()
        .create()
        .build()
        .extensionModelService()
        .loadExtensionModel(newBuilder()
            .withGroupId("org.mule.connectors")
            .withArtifactId("mule-db-connector")
            .withVersion(getMuleDbConnectorTestVersion())
            .withClassifier("mule-plugin")
            .build())
        .get();

    OperationModel select = extensionModel
        .getConfigurationModels()
        .get(0)
        .getOperationModels()
        .stream().filter(op -> op.getName().equals("select"))
        .findFirst()
        .get();

    assertThat(select.getMetadataKeyIdModel().get().getCategoryName().isEnabled(), is(true));
  }

  @Test
  @Description("Validates that new field from 4.1.0 is enabled as feature")
  public void errorModelHandleableFeature() {
    final ExtensionModel extensionModel =
        getToolingRuntimeBootstrap().getToolingRuntimeClientBuilderFactory().create().build().extensionModelService()
            .loadMuleExtensionModels().get(0);
    extensionModel.getErrorModels().stream().forEach(errorModel -> assertThat(errorModel.getHandleable().isEnabled(), is(true)));
  }

  @Override
  protected String getMuleDbConnectorTestVersion() {
    return getMavenProperty(MULE_DB_CONNECTOR_VERSION, POM_FOLDER_FINDER);
  }

}
