/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import org.mule.tooling.client.api.component.location.ArtifactComponentLocations;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;
import org.mule.tooling.client.tests.integration.category.DoesNotNeedMuleRuntimeTest;

import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(DoesNotNeedMuleRuntimeTest.class)
public class ApplicationComponentLocationServiceTestCase extends AbstractComponentLocationServiceTestCase {

  private static final String APP_LOCATION = "applications/component-location";

  @Test
  public void verifyComponentPaths() throws Exception {
    newToolingArtifact();
    ArtifactComponentLocations componentLocations = toolingArtifact.componentLocationService().getComponentLocations();
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 19, 9)).getLocation(),
               is("aggregatorsFlow/processors/0"));
    assertThat(componentLocations.getByLocation("aggregatorsFlow/processors/0").getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 19, 9)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 21, 13)).getLocation(),
               is("aggregatorsFlow/processors/0/route/0"));
    assertThat(componentLocations.getByLocation("aggregatorsFlow/processors/0/route/0").getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 21, 13)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 26, 17)).getLocation(),
               is("aggregatorsFlow/processors/0/route/1/processors/1"));
    assertThat(componentLocations.getByLocation("aggregatorsFlow/processors/0/route/1/processors/1").getSourceCodeLocation()
        .get(),
               is(new SourceCodeLocation("mule-config.xml", 26, 17)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 47, 21)).getLocation(),
               is("batchFlow/processors/0/route/1/processors/0/processors/0"));
    assertThat(componentLocations.getByLocation("batchFlow/processors/0/route/1/processors/0/processors/0")
        .getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 47, 21)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 48, 21)).getLocation(),
               is("batchFlow/processors/0/route/1/processors/0/errorHandler"));
    assertThat(componentLocations.getByLocation("batchFlow/processors/0/route/1/processors/0/errorHandler")
        .getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 48, 21)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 50, 29)).getLocation(),
               is("batchFlow/processors/0/route/1/processors/0/errorHandler/0/processors/0"));
    assertThat(componentLocations.getByLocation("batchFlow/processors/0/route/1/processors/0/errorHandler/0/processors/0")
        .getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 50, 29)));
    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 12, 5)).getLocation(),
               is("config"));
    assertThat(componentLocations.getByLocation("config").getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 12, 5)));
  }

  @Override
  protected String getArtifactLocation() {
    return APP_LOCATION;
  }

}
