/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import org.mule.tooling.client.tests.integration.category.NeedMuleRuntimeTest;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseResolutionScope;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.test.RuntimeType;

import org.junit.experimental.categories.Category;

@Category(NeedMuleRuntimeTest.class)
public abstract class BaseDynamicDataSenseTestCase extends BaseToolingClientTestCase {

  public BaseDynamicDataSenseTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  protected DataSenseRequest createDataSenseRequest(Location location) {

    return createDataSenseRequest(location, null);
  }

  protected DataSenseRequest createDataSenseRequest(DataSenseResolutionScope dataSenseResolutionScope) {
    return createDataSenseRequest(null, dataSenseResolutionScope);
  }

  protected DataSenseRequest createDataSenseRequest(Location location,
                                                    DataSenseResolutionScope dataSenseResolutionScope) {
    DataSenseRequest request = new DataSenseRequest();
    if (location != null) {
      request.setLocation(location);
    } else if (dataSenseResolutionScope != null) {
      request.setDataSenseResolutionScope(dataSenseResolutionScope);
    } else {
      throw new IllegalArgumentException("Neither location nor DataSense resolution scope was specified.");
    }
    return request;
  }

}
