/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import org.mule.tooling.client.api.component.location.ArtifactComponentLocations;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;
import org.mule.tooling.client.tests.integration.category.DoesNotNeedMuleRuntimeTest;

import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(DoesNotNeedMuleRuntimeTest.class)
public class DomainComponentLocationServiceTestCase extends AbstractComponentLocationServiceTestCase {

  private static final String DOMAIN_LOCATION = "domains/component-location";

  @Test
  public void verifyComponentPaths() throws Exception {
    newToolingArtifact();
    ArtifactComponentLocations componentLocations = toolingArtifact.componentLocationService().getComponentLocations();

    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 8, 5)).getLocation(),
               is("web_service_consumer"));
    assertThat(componentLocations.getByLocation("web_service_consumer").getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 8, 5)));

    assertThat(componentLocations.getBySourceCodeLocation(new SourceCodeLocation("mule-config.xml", 12, 5)).getLocation(),
               is("web_service_consumer2"));
    assertThat(componentLocations.getByLocation("web_service_consumer2").getSourceCodeLocation().get(),
               is(new SourceCodeLocation("mule-config.xml", 12, 5)));
  }

  @Override
  protected String getArtifactLocation() {
    return DOMAIN_LOCATION;
  }

}
