/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import static org.mule.tck.junit4.matcher.StringContainsIgnoringLineBreaks.containsStringIgnoringLineBreaks;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getMuleVersion;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getTestLog4JConfigurationFile;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getToolingVersion;

import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.icons.IconsResult;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;

import java.io.IOException;
import java.util.Optional;

import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IconsServiceTestCase {

  private ToolingRuntimeClient toolingClient;
  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  @Before
  public void setUpToolingRuntimeClient() throws Exception {
    ToolingRuntimeClientBootstrap bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                                                    ToolingRuntimeClientBootstrapConfiguration
                                                                                                                        .builder()
                                                                                                                        .muleVersion(getMuleVersion())
                                                                                                                        .toolingVersion(getToolingVersion())
                                                                                                                        .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                                                        .log4jConfiguration(getTestLog4JConfigurationFile())
                                                                                                                        .workingFolder(temporaryFolder
                                                                                                                            .newFolder())
                                                                                                                        .build());
    toolingClient = bootstrap.getToolingRuntimeClientBuilderFactory().create().build();
  }

  @Test
  public void getDefaultIconFromExtension() throws IOException {
    IconsResult iconsResult = toolingClient.iconsService()
        .getIconsFor(ArtifactDescriptor
            .newBuilder()
            .withGroupId("org.mule.connectors")
            .withArtifactId("mule-db-connector")
            .withVersion("1.0.0")
            .withClassifier("mule-plugin")
            .build());
    Optional<byte[]> optionalExtensionIcon = iconsResult.getExtensionIcon();
    assertThat(optionalExtensionIcon.isPresent(), is(true));
    assertThat(new String(optionalExtensionIcon.get()), containsStringIgnoringLineBreaks(getResource("icons/default-icon.svg")));
  }

  @Test
  public void getCustomIconFromExtension() throws IOException {
    IconsResult iconsResult = toolingClient.iconsService()
        .getIconsFor(ArtifactDescriptor
            .newBuilder()
            .withGroupId("org.mule.connectors")
            .withArtifactId("mule-slack-connector")
            .withVersion("4.2.1")
            .withClassifier("mule-plugin")
            .build());
    Optional<byte[]> optionalExtensionIcon = iconsResult.getExtensionIcon();
    assertThat(optionalExtensionIcon.isPresent(), is(true));
    assertThat(new String(optionalExtensionIcon.get()), containsStringIgnoringLineBreaks(getResource("icons/slack-icon.svg")));
  }

  @Test
  public void getIconFromANoExtension() {
    IconsResult iconsResult = toolingClient.iconsService()
        .getIconsFor(ArtifactDescriptor
            .newBuilder()
            .withGroupId("org.mule.runtime")
            .withArtifactId("mule-api")
            .withVersion("1.0.0")
            .build());
    assertThat(iconsResult.getExtensionIcon().isPresent(), is(false));
  }

  private String getResource(String name) throws IOException {
    return IOUtils.toString(Thread.currentThread().getContextClassLoader().getResourceAsStream(name));
  }

}
