/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client;

import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNot.not;
import static org.junit.Assert.assertThat;
import static org.junit.rules.ExpectedException.none;
import static org.mule.maven.client.test.MavenTestHelper.createDefaultEnterpriseMavenConfiguration;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getMuleVersion;
import static org.mule.tooling.client.test.AbstractMuleRuntimeTestCase.getToolingVersion;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.client.tests.integration.category.DoesNotNeedMuleRuntimeTest;

import java.io.File;

import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

@Category(DoesNotNeedMuleRuntimeTest.class)
public class ToolingRuntimeClientBootstrapTestCase {

  @Rule
  public ExpectedException expectedException = none();

  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  @Test
  public void shouldNotFailIfWorkingDirectoryIsNotSet() throws Exception {
    ToolingRuntimeClientBootstrap bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                                                    ToolingRuntimeClientBootstrapConfiguration
                                                                                                                        .builder()
                                                                                                                        .muleVersion(getMuleVersion())
                                                                                                                        .toolingVersion(getToolingVersion())
                                                                                                                        .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                                                        .build());
    assertThat(bootstrap.getToolingRuntimeClientBuilderFactory().create().build(), not(nullValue()));
  }

  @Test
  public void shouldDeleteWorkingDirectoryWhenDisposedToolingBootstrap() throws Exception {
    File workingFolder = temporaryFolder.newFolder();
    ToolingRuntimeClientBootstrap bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                                                    ToolingRuntimeClientBootstrapConfiguration
                                                                                                                        .builder()
                                                                                                                        .muleVersion(getMuleVersion())
                                                                                                                        .toolingVersion(getToolingVersion())
                                                                                                                        .workingFolder(workingFolder)
                                                                                                                        .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                                                        .build());
    assertThat(bootstrap.getToolingRuntimeClientBuilderFactory().create().build(), not(nullValue()));
    bootstrap.dispose();
    assertThat(workingFolder.exists(), is(false));
  }

  @Test
  public void nestedFolderShouldBeCreateIfWorkingDirectoryDoesNotExist() throws Exception {
    File uncreatedWorkingFolder = new File(temporaryFolder.newFolder(), "nestedFolder");
    ToolingRuntimeClientBootstrap bootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap(
                                                                                                                    ToolingRuntimeClientBootstrapConfiguration
                                                                                                                        .builder()
                                                                                                                        .muleVersion(getMuleVersion())
                                                                                                                        .toolingVersion(getToolingVersion())
                                                                                                                        .workingFolder(uncreatedWorkingFolder)
                                                                                                                        .mavenConfiguration(createDefaultEnterpriseMavenConfiguration())
                                                                                                                        .build());
    assertThat(bootstrap.getToolingRuntimeClientBuilderFactory().create().build(), not(nullValue()));
    assertThat(uncreatedWorkingFolder.exists(), is(true));
  }

}
