/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.tests.integration.tooling.client.metadata;

import static java.util.Optional.empty;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.client.api.component.location.Location.builder;
import static org.mule.tooling.client.api.datasense.DataSenseNotificationType.errorDataSenseNotificationType;
import static org.mule.tooling.client.tests.integration.tooling.client.DataSenseNotificationMatcher.notificationTypeIs;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.test.RuntimeType;

import java.util.Optional;

import org.junit.Test;

public class DynamicMetadataFilteredByMuleRuntimeTargetVersionTestCase extends AbstractMetadataCacheTestCase {

  public DynamicMetadataFilteredByMuleRuntimeTargetVersionTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Override
  protected void doSetUpToolingRuntimeClient(ToolingRuntimeClient.Builder builder) {
    builder.withTargetRuntimeVersion().ifEnabled(action -> action.perform("4.1.0"));
  }

  @Test
  public void outputMimeTypeParameter() {
    doWithToolingArtifact(remoteToolingRuntimeClient(), getApplicationUrlContent("applications/output-mime-type-parameter"),
                          toolingArtifact -> {
                            DataSenseRequest dataSenseRequestAccount = new DataSenseRequest();
                            Location accountLocation =
                                builder().globalName("fetchMetadata").addProcessorsPart().addIndexPart(0).build();
                            dataSenseRequestAccount.setLocation(accountLocation);

                            assertRuntimeMetadataCache(toolingArtifact, dataSenseRequestAccount);
                          });
  }

  private void assertRuntimeMetadataCache(ToolingArtifact toolingArtifact, DataSenseRequest dataSenseRequest) {
    Optional<DataSenseComponentInfo> dataSenseComponentInfoOptional =
        toolingArtifact.dataSenseService().resolveComponentDataSense(dataSenseRequest);
    assertThat(dataSenseComponentInfoOptional, not(empty()));

    DataSenseComponentInfo dataSenseComponentInfo = dataSenseComponentInfoOptional.get();
    assertThat(dataSenseComponentInfo.getDataSenseNotifications(),
               not(hasItem(notificationTypeIs(errorDataSenseNotificationType("ERROR")))));

    assertThat(dataSenseComponentInfo.getOperationModel().get().getParameterGroupModel("General").get()
        .getParameterModel("outputMimeType"), equalTo(empty()));
  }

}
