/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static java.util.Optional.ofNullable;

import java.util.Objects;
import java.util.Optional;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * A model which provides directives about how the model should be shown in the user interface.
 *
 * @since 1.0
 */
public class DisplayModel {

  private String displayName;
  private String summary;
  private String example;
  private PathModel pathModel;

  // Just needed in order to serialize this object
  private DisplayModel() {}

  public DisplayModel(String displayName, String summary, String example, PathModel pathModel) {
    this.displayName = displayName;
    this.summary = summary;
    this.example = example;
    this.pathModel = pathModel;
  }

  /**
   * @return The name which should be use to show this model
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * @return A very brief overview about this model
   */
  public String getSummary() {
    return summary;
  }

  /**
   * @return An example of the content that should be used
   */
  public String getExample() {
    return example;
  }

  public Optional<PathModel> getPathModel() {
    return ofNullable(pathModel);
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof DisplayModel) {
      DisplayModel other = ((DisplayModel) obj);
      return Objects.equals(other.getDisplayName(), this.getDisplayName()) &&
          Objects.equals(other.getSummary(), this.getSummary()) &&
          Objects.equals(other.getPathModel(), this.getPathModel()) &&
          Objects.equals(other.getExample(), this.getExample());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayName, summary, example, pathModel);
  }

  @Override
  public String toString() {
    return ToStringBuilder.reflectionToString(this);
  }
}
