/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.dsl;

import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;

import java.util.Optional;

/**
 * Provides the {@link DslElementSyntax} of any {@code Component}, {@link ParameterModel Parameter} or
 * {@link MetadataType Type} within the context of the {@link ExtensionModel Extension model} where the Component was declared.
 *
 * @since 1.0
 */
public interface DslSyntaxResolver extends Disposable {

  /**
   * Resolves the {@link DslElementSyntax} for the given {@link ConfigurationModel component}.
   *
   * @param component the {@link ConfigurationModel} element to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the {@link ConfigurationModel model}
   */
  DslElementSyntax resolve(final ConfigurationModel component);

  /**
   * Resolves the {@link DslElementSyntax} for the given {@link ConnectionProviderModel component}.
   *
   * @param component the {@link ConnectionProviderModel} element to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the {@link ConnectionProviderModel model}
   */
  DslElementSyntax resolve(final ConnectionProviderModel component);

  /**
   * Resolves the {@link DslElementSyntax} for the given {@link ConstructModel component}.
   *
   * @param component the {@link ConstructModel} element to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the {@link ConstructModel model}
   */
  DslElementSyntax resolve(final ConstructModel component);

  /**
   * Resolves the {@link DslElementSyntax} for the given {@link OperationModel component}.
   *
   * @param component the {@link OperationModel} element to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the {@link OperationModel model}
   */
  DslElementSyntax resolve(final OperationModel component);

  /**
   * Resolves the {@link DslElementSyntax} for the given {@link SourceModel component}.
   *
   * @param component the {@link SourceModel} element to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the {@link SourceModel model}
   */
  DslElementSyntax resolve(final SourceModel component);

  /**
   * Resolves the {@link DslElementSyntax} for the standalone xml element for the given {@link MetadataType}
   *
   * @param type the {@link MetadataType} to be described in the {@link DslElementSyntax}
   * @return the {@link DslElementSyntax} for the top level element associated to the {@link MetadataType} or
   *         {@link Optional#empty} if the {@code type} is not supported as an standalone element
   */
  Optional<DslElementSyntax> resolve(MetadataType type);

}
