/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.connectivity;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.request.AbstractToolingRequest;
import org.mule.tooling.client.api.artifact.ToolingArtifact;

/**
 * Request entity for connectivity testing over global elements of a {@link ToolingArtifact}.
 *
 * @since 1.0
 */
public final class ConnectivityTestingRequest extends AbstractToolingRequest {

  private String componentId;

  /**
   * Sets the identifies a global element from the {@link ToolingArtifact} configuration.
   *
   * @param componentId identifies a global element from the {@link ToolingArtifact} configuration.
   */
  public void setComponentId(String componentId) {
    requireNonNull(componentId, "componentId cannot null");
    this.componentId = componentId;
  }

  /**
   * @return the identifier of the global element from the {@link ToolingArtifact} configuration.
   */
  public String getComponentId() {
    return componentId;
  }

  @Override
  public String toString() {
    return format("%s{requestTimeout=%s,componentId=%s}", getShortClassName(this.getClass()), getRequestTimeout(),
                  getComponentId());
  }

}
