/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Classifies the generic location where the path is allowed to point
 */
public class PathModelLocation extends UnknownType {

  private boolean embedded = false;
  private boolean external = false;
  private boolean any = false;

  public static PathModelLocation embeddedPathModelLocation(String value) {
    PathModelLocation loc = new PathModelLocation(value);
    loc.embedded = true;

    return loc;
  }

  public static PathModelLocation externalPathModelLocation(String value) {
    PathModelLocation loc = new PathModelLocation(value);
    loc.external = true;

    return loc;
  }

  public static PathModelLocation anyPathModelLocation(String value) {
    PathModelLocation loc = new PathModelLocation(value);
    loc.any = true;

    return loc;
  }

  // Just needed in order to serialize this object
  public PathModelLocation() {}

  public PathModelLocation(String value) {
    super(value);
  }

  public boolean isEmbedded() {
    return embedded;
  }

  public boolean isExternal() {
    return external;
  }

  public boolean isAny() {
    return any;
  }
}
