/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

import java.util.List;

import org.junit.Test;

public class DefaultArrayTypeConverterTestCase {

  private static final String DESCRIPTION = "description";

  @Test
  public void keepAnnotationsAtArrayTypeLevel() {
    StringType stringType = new BaseTypeBuilder(JAVA)
        .stringType()
        .with(new ClassInformationAnnotation(String.class))
        .build();

    ArrayType arrayType = new BaseTypeBuilder(JAVA)
        .arrayType()
        .description(DESCRIPTION)
        .of(stringType)
        .with(new ClassInformationAnnotation(List.class))
        .build();

    XStreamClientSerializer serializer = new XStreamClientSerializer(this.getClass().getClassLoader());
    String xml = serializer.serialize(arrayType);
    ArrayType deserialized = serializer.deserialize(xml);

    assertThat(deserialized.getAnnotation(ClassInformationAnnotation.class).isPresent(), is(true));
  }
}
