/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.component.location;

import static java.util.Optional.ofNullable;
import org.mule.tooling.client.api.component.TypedComponentIdentifier;

import java.util.Optional;

/**
 * A location part represent an specific location of a component within another component.
 *
 * @since 1.0
 */
public class LocationPart {

  private String path;
  private String fileName;
  private Integer lineInFile;
  private TypedComponentIdentifier identifier;

  private LocationPart() {}

  public LocationPart(String path, String fileName, Integer lineInFile, TypedComponentIdentifier identifier) {
    this.path = path;
    this.fileName = fileName;
    this.lineInFile = lineInFile;
    this.identifier = identifier;
  }

  /**
   * @return the string representation of the part
   */
  public String getPartPath() {
    return path;
  }

  /**
   * A location part represent an specific location of a component within another component.
   *
   * @since 4.0
   */
  public Optional<TypedComponentIdentifier> getPartIdentifier() {
    return ofNullable(identifier);
  }

  /**
   * @return the config file of the application where this component is defined, if it was defined in a config file.
   */
  public Optional<String> getFileName() {
    return ofNullable(fileName);
  }

  /**
   * @return the line number in the config file of the application where this component is defined, if it was defined in a config file.
   */
  public Optional<Integer> getLineInFile() {
    return ofNullable(lineInFile);
  }

}
